/* $Id: proc_partitions.c,v 1.4 2003/10/12 10:40:15 short Exp $
 * /proc/partitions file reader for installers of captive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#undef FALSE
#undef TRUE
#include <ntfs/types.h>	/* for 'FALSE'/'TRUE' libntfs definition */
#define FALSE FALSE
#define TRUE TRUE

#include "proc_partitions.h"	/* self */
#include <glib/gmessages.h>
#include <popt.h>
#include <locale.h>
#include <stdlib.h>
#include <string.h>
#include <mntent.h>
#include <glib/ghash.h>
#include <glib/gstrfuncs.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>

#include <captive/macros.h>

#include <ntfs/volume.h>


/* Config: */
#define FILENAME_PROC_PARTITIONS  "/proc/partitions"


static void proc_partitions_ntfs_hash_key_destroy_func(gchar *device)
{
	g_return_if_fail(device!=NULL);

	g_free(device);
}

static void proc_partitions_ntfs_hash_value_destroy_func(gchar *vol_name)
{
	g_return_if_fail(vol_name!=NULL);

	g_free(vol_name);
}


GHashTable *proc_partitions_ntfs_hash_get(gboolean msg_verbose)
{
FILE *fpartitions;
gchar line[LINE_MAX];
gint lineno;
/* map: (gchar *)device -> (gchar *)vol_name */
GHashTable *proc_partitions_ntfs_hash;

	proc_partitions_ntfs_hash=g_hash_table_new_full(g_str_hash,g_str_equal,
			(GDestroyNotify)proc_partitions_ntfs_hash_key_destroy_func,
			(GDestroyNotify)proc_partitions_ntfs_hash_value_destroy_func);

	if (!(fpartitions=fopen(FILENAME_PROC_PARTITIONS,"r")))
		g_error(_("Cannot open \"%s\": %m"),FILENAME_PROC_PARTITIONS);
	lineno=0;
	while (fgets(line,sizeof(line),fpartitions)) {
unsigned major,minor;
unsigned long long blocks;
char device[strlen("/dev/")+100];
ntfs_volume *volume;

		lineno++;
		if (lineno<=2)
			continue;
		if (!*line || *line=='\n') {
			/* At least RedHat Linux kernel 2.4.18-18.8.0 sometimes appends
			 * bogus empty line at the end of file.
			 */
			continue;
			}
		if (4!=sscanf(line,"%u%u%llu%100s",&major,&minor,&blocks,device+strlen("/dev/"))) {
			g_warning(_("Error parsing line of \"%s\" (Linux kernel bug): %s"),FILENAME_PROC_PARTITIONS,line);
			continue;
			}
		memcpy(device,"/dev/",strlen("/dev/"));
		if (!(volume=ntfs_mount(device,MS_RDONLY))) {
			if (msg_verbose)
				g_message(_("not ntfs: %s"),device);
			continue;
			}
		if (msg_verbose)
			g_message(_("FOUND ntfs: %s\t%s"),device,volume->vol_name);
		g_hash_table_insert(proc_partitions_ntfs_hash,g_strdup(device),g_strdup(volume->vol_name));
		if (ntfs_umount(volume,
				TRUE))	/* force; close even if it would mean data loss */
			g_warning(_("Error unmounting volume: %s"),device);
		}
	if (fclose(fpartitions))
		g_warning(_("Cannot close \"%s\": %m"),FILENAME_PROC_PARTITIONS);
	return proc_partitions_ntfs_hash;
}
