#! /bin/sh
# 
# $Id: compatibility-test.sh,v 1.2 2005/12/26 12:16:24 lace Exp $
# Test compatibility of the "ntfs.sys" and "ntoskrnl.exe" files.
# Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; exactly version 2 of June 1991 is required
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


# Example result:
# <!--
#  - Test of ntfs.sys and ntoskrnl.exe compatibility:
#  - export_fail means: Export not found for: %d:%s
#  - 9499==ntfs(5+extra(2))*ntoskrnl(1352+extra(5))==export_fail(2130)+ok(7369)
#  -->


set -e
#set -x

# Directory containing /ntfs.sys/* and /ntoskrnl.exe/* files to test. 
out="$1"

# Second directory containing files exactly like $out; appended.
out_extra="$2"

# Binary regular file containing NTFS image with >=1500k of free space.
# This file is never modified.
image="$3"


test -d "$out"
test -d "$out_extra"
test -f "$image"

# Test commit() at the written 1MB:
head -qc 1500k /dev/urandom >/tmp/captive-sanity-orig.bin
rm -rf /tmp/captive-sanity-module
mkdir /tmp/captive-sanity-module

: >/tmp/captive-sanity-out-all

count_ntfs=`    echo $out/ntfs.sys/*     $out_extra/ntfs.sys/*    |tr ' ' '\n'|wc -l`
count_ntoskrnl=`echo $out/ntoskrnl.exe/* $out_extra/ntoskrnl.exe/*|tr ' ' '\n'|wc -l`
count_combo=$[$count_ntfs*$count_ntoskrnl]

total_passed=0
total_export=0
total_error=0
total_ok=0

cat <<HERE >/tmp/captive-sanity-command
put /tmp/captive-sanity-orig.bin sanity.bin
get sanity.bin /tmp/captive-sanity-copy.bin
quit
HERE

for ntfs_sys     in $out/ntfs.sys/*     $out_extra/ntfs.sys/*    ;do
rm -f /tmp/captive-sanity-module/ntfs.sys
ln $ntfs_sys /tmp/captive-sanity-module/ntfs.sys

for ntoskrnl_exe in $out/ntoskrnl.exe/* $out_extra/ntoskrnl.exe/*;do
rm -f /tmp/captive-sanity-module/ntoskrnl.exe
ln $ntoskrnl_exe /tmp/captive-sanity-module/ntoskrnl.exe

rm -f /tmp/captive-sanity-copy.bin
set +e
../../client/cmdline/captive-cmdline </tmp/captive-sanity-command \
		--sandbox-server="./src/client/sandbox-server/captive-sandbox-server --setuid=- --setgid=- --chroot=- --no-rlimit" \
		--disk --blind \
		--filesystem=/tmp/captive-sanity-module/ntfs.sys \
		--load-module=/tmp/captive-sanity-module/ntoskrnl.exe \
		"$image" \
		&>/tmp/captive-sanity-out
error=$?
set -e
if grep -q 'Export not found for: ' /tmp/captive-sanity-out;then
	total_export=$[$total_export+1]
elif [ $error -ne 0 ];then
	total_error=$[$total_error+1]
	cat /tmp/captive-sanity-out
	cat <<HERE >>/tmp/captive-sanity-out-all
--------
ntfs.sys=$ntfs_sys
ntoskrnl.exe=$ntoskrnl_exe
HERE
	cat /tmp/captive-sanity-out >>/tmp/captive-sanity-out-all
else
	cmp /tmp/captive-sanity-orig.bin /tmp/captive-sanity-copy.bin
	total_ok=$[$total_ok+1]
fi
rm -f /tmp/captive-sanity-copy.bin

total_passed=$[$total_passed+1]
echo "done: $total_passed of $count_combo [total_export=$total_export total_error=$total_error total_ok=$total_ok]"

done
done 2>&1 | grep -v 'sanity: line .*: .* Aborted.*captive-cmdline'

rm -rf /tmp/captive-sanity-module
rm -f /tmp/captive-sanity-orig.bin
rm -f /tmp/captive-sanity-command

echo "--------"
cat /tmp/captive-sanity-out-all

echo "--------"
echo /tmp/captive-sanity-out-all

# Do not: echo "total_export=$total_export"
#         echo "total_error=$total_error"
#         echo "total_ok=$total_ok"
# as the variables will not pass out of the 'for...done' loop above.
