/* $Id: bcbowner.c,v 1.2 2003/08/13 09:00:07 short Exp $
 * reactos Cache Manager (Cc*) owner handling of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "privatebcbpin.h"
#include "privatebcb.h"


/**
 * CcSetBcbOwnerPointer:
 * @Bcb: Initialized #PUBLIC_BCB structure.
 * %NULL value is forbidden.
 * @Owner: Thread-specific pointer (FIXME: Is it KeGetCurrentThread()?).
 * %NULL value is forbidden (FIXME: Is it W32 compliant?).
 *
 * Set thread-specific pointer for a pinned @Bcb. Use CcUnpinDataForThread()
 * when @Bcb is no longer needed. CcUnpinDataForThread() is NOT a reverse
 * operation for this single call CcSetBcbOwnerPointer(), see CcUnpinDataForThread().
 *
 * libcaptive implements this function as no-operation as it does not yet
 * support any threading.
 */
VOID CcSetBcbOwnerPointer(IN PVOID Bcb,IN PVOID Owner)
{
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object;

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"enter: CcSetBcbOwnerPointer: Bcb=0x%lX,OwnerPointer=0x%lX",
			(long)Bcb,(long)Owner);

	g_return_if_fail(Bcb!=NULL);
	g_return_if_fail(Owner!=NULL);

	captive_private_bcb_pin_object=CAPTIVE_PRIVATE_BCB_PIN_OBJECT(captive_PublicBcb_to_PrivateBcbObject(Bcb));

	captive_private_bcb_pin_object_detach_pin(captive_private_bcb_pin_object);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"leave: CcSetBcbOwnerPointer");
}


/**
 * CcUnpinDataForThread:
 * @Bcb: Initialized #PUBLIC_BCB structure.
 * %NULL value is forbidden.
 * @ResourceThreadId: Thread-specific pointer (FIXME: Is it KeGetCurrentThread()?).
 * This pointer had to be passed to CcSetBcbOwnerPointer() #Owner parameter previously.
 * %NULL value is forbidden (FIXME: is it W32 compliant?).
 *
 * CcUnpinData() for a thread specified by @ResourceThreadId.
 * Reverse operation for a pair of CcMapData() and CcSetBcbOwnerPointer().
 *
 * libcaptive implements this function as a simple pass to CcUnpinData() as it does not yet
 * support any threading.
 */
VOID CcUnpinDataForThread(IN PVOID Bcb,IN ERESOURCE_THREAD ResourceThreadId)
{
CaptivePrivateBcbObject *captive_private_bcb_object;

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"enter: CcUnpinDataForThread: Bcb=0x%lX,ResourceThreadId=0x%lX",
			(long)Bcb,(long)ResourceThreadId);

	g_return_if_fail(Bcb!=NULL);
	g_return_if_fail(ResourceThreadId!=0);

	captive_private_bcb_object=captive_PublicBcb_to_PrivateBcbObject(Bcb);

	g_object_unref(captive_private_bcb_object);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"leave: CcUnpinDataForThread");
}
