/* $Id: bcbrepin.c,v 1.2 2003/08/13 09:10:29 short Exp $
 * reactos Cache Manager (Cc*) map/pin Bcb CcRepin*() handling of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "privatebcb.h"
#include "reactos/ddk/status.h"
#include "privatebcbpin.h"


/**
 * CcRepinBcb:
 * @Bcb: #PUBLIB_BCB to be repinned.
 * %NULL value is forbidden.
 *
 * Increases usecount on @Bcb. You must call CcUnpinRepinnedBcb() for such @Bcb
 * afterwards before returning from the #IRP handling.
 *
 * libcaptive does not differentiate between CcUnpinData() and CcUnpinRepinnedBcb().
 * W32 differentiates.
 *
 * This call does not set the buffer as dirty - such buffer will not be flushed automatically.
 *
 */
VOID CcRepinBcb(IN PVOID Bcb)
{
CaptivePrivateBcbObject *captive_private_bcb_object;

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"enter: CcRepinBcb: Bcb=0x%lX",(long)Bcb);

	g_return_if_fail(Bcb!=NULL);

	captive_private_bcb_object=captive_PublicBcb_to_PrivateBcbObject(Bcb);

	g_object_ref(captive_private_bcb_object);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"leave: CcRepinBcb");
}


/**
 * CcUnpinRepinnedBcb:
 * @Bcb: #PUBLIB_BCB to be unpinned from CcRepinBcb().
 * %NULL value is forbidden.
 * @WriteThrough: %TRUE if the buffer should be flushed before finishing this function.
 * @IoStatus: #PIO_STATUS_BLOCK to return status of this operation.
 * %NULL value is forbidden. libcaptive always returns %STATUS_SUCCESS here.
 *
 * Dereferencing of @Bcb after application of CcRepinBcb().
 *
 * This call does not set the buffer as dirty although it will flush the buffers
 * already set as dirty. Any flushes will be postponed after return from #IRP
 * handling by the filesystem driver if not requested to be synchronous by @WriteThrough.
 */
VOID CcUnpinRepinnedBcb(IN PVOID Bcb,IN BOOLEAN WriteThrough,IN PIO_STATUS_BLOCK IoStatus)
{
CaptivePrivateBcbObject *captive_private_bcb_object;

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"enter: CcUnpinRepinnedBcb: Bcb=0x%lX,WriteThrough=%d",
			(long)Bcb,WriteThrough);

	g_return_if_fail(Bcb!=NULL);
	g_return_if_fail(IoStatus!=NULL);

	captive_private_bcb_object=captive_PublicBcb_to_PrivateBcbObject(Bcb);

	IoStatus->Status=STATUS_SUCCESS;
	IoStatus->Information=0;

	if (WriteThrough) {	/* FIXME: WriteThrough even if we do not do the last unref? */
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object;

		captive_private_bcb_pin_object=CAPTIVE_PRIVATE_BCB_PIN_OBJECT(captive_private_bcb_object);
		if (captive_private_bcb_pin_object_is_dirty(captive_private_bcb_pin_object)) {
			captive_private_bcb_pin_object_flush(captive_private_bcb_pin_object);
			IoStatus->Information=PAGE_SIZE;
			}
		}

	g_object_unref(captive_private_bcb_object);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"leave: CcUnpinRepinnedBcb: IoStatus->Status=0x%lX,IoStatus->Information=0x%lX",
			(!IoStatus ? -1 : (long)IoStatus->Status),(!IoStatus ? -1 : (long)IoStatus->Information));
}
