/* $Id: bcbunpin.c,v 1.2 2003/08/13 09:02:14 short Exp $
 * reactos Cache Manager (Cc*) map/pin Bcb CcUnpinData() handling of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "privatebcb.h"


/**
 * CcUnpinData:
 * @Bcb: Initialized #PUBLIC_BCB structure.
 * %NULL value is forbidden.
 *
 * Dereferences @Bcb with the possible cleanup operations if you were the last owner.
 *
 * This call does not set the buffer as dirty although it will flush the buffers
 * already set as dirty. Any flushes will be postponed after return from #IRP
 * handling by the filesystem driver.
 */
VOID CcUnpinData(IN PVOID Bcb)
{
CaptivePrivateBcbObject *captive_private_bcb_object;

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"enter: CcUnpinData: Bcb=0x%lX",(long)Bcb);

	g_return_if_fail(Bcb!=NULL);

	captive_private_bcb_object=captive_PublicBcb_to_PrivateBcbObject(Bcb);

	g_object_unref(captive_private_bcb_object);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"leave: CcUnpinData");
}
