/* $Id: dirtypages.c,v 1.3 2004/01/18 10:06:39 short Exp $
 * reactos Cache Manager (Cc*) cache handling of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "privatebcbpin.h"


/**
 * CcGetDirtyPages:
 * @LogHandle: Arbitrary pointer to match with value passed to CcSetLogHandleForFile().
 * %NULL value is permitted (considered as regular matching value by libcaptive).
 * @DirtyPageRoutine: #PDIRTY_PAGE_ROUTINE type to call on each dirty page(s).
 * %NULL value is forbidden.
 * @Context1: User data to pass to @DirtyPageRoutine.
 * %NULL value is permitted.
 * @Context2: User data to pass to @DirtyPageRoutine.
 *
 * Searches through the list of dirty #PUBLIC_BCB s of files assigned to @LogHandle
 * by CcSetLogHandleForFile(). Any clean #PUBLIC_BCB s are ignored
 * by this function. Function will scan through all #PUBLIC_BCB mapping of each such page
 * and it will detect its oldest and newest LSN (Logical Sequence Number). Unset
 * LSN is considered as value 0. Value 0 is returned only if no other LSN is valid
 * for such case, otherwise such void value 0 is ignored (and oldest and newest LSN
 * returned are being equal in the case only single LSN was found).
 *
 * Found pages are coalesced as much as possible during calls of @DirtyPageRoutine.
 * Coalescable ranges must have the same detected both oldest and newest LSNs.
 *
 * Returns: Oldest LSN across all the #FileObject s found for the given @LogHandle.
 * Function returns value %0 if no appropriate LSN was found.
 * libcaptive must return #gint64 instead of the official #LARGE_INTEGER
 * as W32 expects it as value in EAX:EDX but GCC returns the structure address in EAX.
 *
 * VERIFIED: func called in runs for each FileObject, FileOffset sorted desc.
 */
gint64 /* instead of LARGE_INTEGER */ CcGetDirtyPages(IN PVOID LogHandle,
		IN PDIRTY_PAGE_ROUTINE DirtyPageRoutine,IN PVOID Context1,IN PVOID Context2)
{
gint64 r;

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"enter: CcGetDirtyPages: LogHandle=0x%lX,DirtyPageRoutine=0x%lX,Context1=0x%lX,Context2=0x%lX",
			(long)LogHandle,(long)DirtyPageRoutine,(long)Context1,(long)Context2);

	/* 'LogHandle' may be NULL */
	g_return_val_if_fail(DirtyPageRoutine!=NULL,0);

	/* W32 undocumented: What does mean LogHandle==NULL?
	 * It is expected to clear the 'LogHandle' settings.
	 * Otherwise it would cause multiple active 'LogHandle's for some NT4 NTFS drives
	 * as reported by Nerijus Baliunas in: <20040106005157.7E5C060BE@mx.ktv.lt>
	 */

	captive_shared_cache_map_set_LogHandle(NULL,LogHandle);

	r=captive_shared_cache_map_CcGetDirtyPages(DirtyPageRoutine,Context1,Context2);

	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"leave: CcGetDirtyPages: r=0x%lX",(long)r);

	return r;
}
