/* $Id: mm.c,v 1.1 2003/11/30 10:07:25 short Exp $
 * reactos Cache Manager (Cc*) memory management interaction of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/mmfuncs.h"	/* self */
#include "sharedcachemap.h"


/**
 * MmSetAddressRangeModified:
 * @Address: Start of the memory block.
 * %NULL value is forbidden.
 * FIXME: Must be the value %PAGE_SIZE aligned? libcaptive does not require it now.
 * @Length: Length of the memory block.
 * Value may not be %PAGE_SIZE aligned.
 *
 * Set the specified memory range as modified.
 *
 * Returns: %TRUE if any pages in the range were set as modified.
 * FIXME: libcaptive currently returns %TRUE even if they were already set as modified.
 * Is it W32 compliant?
 */
BOOLEAN MmSetAddressRangeModified(IN PVOID Address,IN SIZE_T Length)
{
	g_return_val_if_fail(Address!=NULL,FALSE);

	return !!captive_shared_cache_map_memory_range_set_dirty(Address,Address+Length);
}
