/* $Id: privatebcb.c,v 1.2 2003/09/09 18:49:29 short Exp $
 * reactos Cache Manager (Cc*) PrivateBcb structure of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "privatebcb.h"	/* self */
#include "privatebcb-priv.h"	/* self */
#include <glib-object.h>
#include "captive/macros.h"
#include <glib/ghash.h>


/* CONFIG: */

#define CAPTIVE_PUBLIC_BCB_NODETYPECODE 0xDE45	/* FIXME: W32 undocumented */


static GHashTable *CaptivePrivateBcbObject_hash;

static void CaptivePrivateBcbObject_hash_init(void)
{
	if (CaptivePrivateBcbObject_hash)
		return;
	CaptivePrivateBcbObject_hash=g_hash_table_new(
			g_direct_hash,	/* hash_func */
			g_direct_equal);	/* key_equal_func */
}

static gpointer captive_private_bcb_object_parent_class=NULL;


static void captive_private_bcb_object_finalize(CaptivePrivateBcbObject *captive_private_bcb_object)
{
	g_return_if_fail(captive_private_bcb_object!=NULL);

	if (captive_private_bcb_object->SharedCacheMap) {
		g_object_unref(captive_private_bcb_object->SharedCacheMap);
		captive_private_bcb_object->SharedCacheMap=NULL;
		}
	if (captive_private_bcb_object->PublicBcb) {
		g_free(captive_private_bcb_object->PublicBcb);
		captive_private_bcb_object->PublicBcb=NULL;
		}

	G_OBJECT_CLASS(captive_private_bcb_object_parent_class)->finalize((GObject *)captive_private_bcb_object);
}


static void captive_private_bcb_object_class_init(CaptivePrivateBcbObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_private_bcb_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_private_bcb_object_finalize;
}


static void captive_private_bcb_object_init(CaptivePrivateBcbObject *captive_private_bcb_object)
{
PUBLIC_BCB *PublicBcb;

	captive_new(PublicBcb);
	PublicBcb->NodeTypeCode=CAPTIVE_PUBLIC_BCB_NODETYPECODE;
	PublicBcb->NodeByteSize=sizeof(*PublicBcb);	/* we have no extensions there */
	PublicBcb->MappedLength=0;
	PublicBcb->MappedFileOffset.QuadPart=0;
	captive_private_bcb_object->PublicBcb=PublicBcb;
	CaptivePrivateBcbObject_hash_init();
	g_hash_table_insert(CaptivePrivateBcbObject_hash,PublicBcb,captive_private_bcb_object);
}


GType captive_private_bcb_object_get_type(void)
{
static GType captive_private_bcb_object_type=0;

	if (!captive_private_bcb_object_type) {
static const GTypeInfo captive_private_bcb_object_info={
				sizeof(CaptivePrivateBcbObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_private_bcb_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptivePrivateBcbObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_private_bcb_object_init,
				};

		captive_private_bcb_object_type=g_type_register_static(G_TYPE_OBJECT,
				"CaptivePrivateBcbObject",&captive_private_bcb_object_info,G_TYPE_FLAG_ABSTRACT);
		}

	return captive_private_bcb_object_type;
}

void _captive_private_bcb_object_connect_SharedCacheMap
		(CaptivePrivateBcbObject *captive_private_bcb_object,CaptiveSharedCacheMapObject *SharedCacheMap)
{
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_IS_OBJECT(captive_private_bcb_object));
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(SharedCacheMap));
	g_return_if_fail(captive_private_bcb_object->SharedCacheMap==NULL);

	g_object_ref(SharedCacheMap);
	captive_private_bcb_object->SharedCacheMap=SharedCacheMap;
}

PUBLIC_BCB *captive_private_bcb_object_get_PublicBcb(CaptivePrivateBcbObject *captive_private_bcb_object)
{
	g_return_val_if_fail(CAPTIVE_PRIVATE_BCB_IS_OBJECT(captive_private_bcb_object),NULL);

	return captive_private_bcb_object->PublicBcb;
}

CaptiveSharedCacheMapObject *captive_private_bcb_object_get_SharedCacheMap(CaptivePrivateBcbObject *captive_private_bcb_object)
{
	g_return_val_if_fail(CAPTIVE_PRIVATE_BCB_IS_OBJECT(captive_private_bcb_object),NULL);
	g_return_val_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_private_bcb_object->SharedCacheMap),NULL);

	return captive_private_bcb_object->SharedCacheMap;
}

CaptivePrivateBcbObject *captive_PublicBcb_to_PrivateBcbObject(const PUBLIC_BCB *PublicBcb)
{
CaptivePrivateBcbObject *captive_private_bcb_object;

	g_return_val_if_fail(PublicBcb!=NULL,NULL);

	CaptivePrivateBcbObject_hash_init();
	captive_private_bcb_object=g_hash_table_lookup(CaptivePrivateBcbObject_hash,PublicBcb);
	g_return_val_if_fail(CAPTIVE_PRIVATE_BCB_IS_OBJECT(captive_private_bcb_object),NULL);

	return captive_private_bcb_object;
}
