/* $Id: privatebcb.h,v 1.1 2003/08/12 17:43:09 short Exp $
 * Include file for reactos Cache Manager (Cc*) PrivateBcb structure of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CC_PRIVATE_BCB_H
#define _CAPTIVE_CC_PRIVATE_BCB_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include "sharedcachemap.h"


G_BEGIN_DECLS

#define CAPTIVE_PRIVATE_BCB_TYPE_OBJECT            (captive_private_bcb_object_get_type())
#define CAPTIVE_PRIVATE_BCB_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_PRIVATE_BCB_TYPE_OBJECT,CaptivePrivateBcbObject))
#define CAPTIVE_PRIVATE_BCB_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_PRIVATE_BCB_TYPE_OBJECT,CaptivePrivateBcbObjectClass))
#define CAPTIVE_PRIVATE_BCB_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_PRIVATE_BCB_TYPE_OBJECT))
#define CAPTIVE_PRIVATE_BCB_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_PRIVATE_BCB_TYPE_OBJECT))
#define CAPTIVE_PRIVATE_BCB_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_PRIVATE_BCB_TYPE_OBJECT,CaptivePrivateBcbObjectClass))
typedef struct _CaptivePrivateBcbObject      CaptivePrivateBcbObject;
typedef struct _CaptivePrivateBcbObjectClass CaptivePrivateBcbObjectClass;


GType captive_private_bcb_object_get_type(void);

void _captive_private_bcb_object_connect_SharedCacheMap
		(CaptivePrivateBcbObject *captive_private_bcb_object,CaptiveSharedCacheMapObject *SharedCacheMap);
PUBLIC_BCB *captive_private_bcb_object_get_PublicBcb(CaptivePrivateBcbObject *captive_private_bcb_object);
CaptiveSharedCacheMapObject *captive_private_bcb_object_get_SharedCacheMap(CaptivePrivateBcbObject *captive_private_bcb_object);
CaptivePrivateBcbObject *captive_PublicBcb_to_PrivateBcbObject(const PUBLIC_BCB *PublicBcb);

G_END_DECLS


#endif /* _CAPTIVE_CC_PRIVATE_BCB_H */
