/* $Id: privatebcbmap.c,v 1.2 2003/09/09 18:50:15 short Exp $
 * reactos Cache Manager (Cc*) PrivateBcb Map type structure of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "privatebcbmap.h"	/* self */
#include "privatebcb.h"
#include "privatebcb-priv.h"
#include "sharedcachemap-priv.h"
#include <glib-object.h>


struct _CaptivePrivateBcbMapObject {
	CaptivePrivateBcbObject parent_instance;
	};
struct _CaptivePrivateBcbMapObjectClass {
	CaptivePrivateBcbObjectClass parent_class;
	};


static gpointer captive_private_bcb_map_object_parent_class=NULL;


static void captive_private_bcb_map_object_finalize(CaptivePrivateBcbMapObject *captive_private_bcb_map_object)
{
CaptivePrivateBcbObject *captive_private_bcb_object;
CaptiveSharedCacheMapObject *captive_shared_cache_map_object;

	g_return_if_fail(captive_private_bcb_map_object!=NULL);

	captive_private_bcb_object=CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_map_object);

	if ((captive_shared_cache_map_object=captive_private_bcb_object->SharedCacheMap)) {
		g_assert(captive_shared_cache_map_object->map==captive_private_bcb_map_object);
		captive_shared_cache_map_object->map=NULL;
		g_object_unref(captive_shared_cache_map_object);	/* 'map' disconnected. */
		}

	G_OBJECT_CLASS(captive_private_bcb_map_object_parent_class)->finalize((GObject *)captive_private_bcb_map_object);
}


static void captive_private_bcb_map_object_class_init(CaptivePrivateBcbMapObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_private_bcb_map_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_private_bcb_map_object_finalize;
}


static void captive_private_bcb_map_object_init(CaptivePrivateBcbMapObject *captive_private_bcb_map_object)
{
}


GType captive_private_bcb_map_object_get_type(void)
{
static GType captive_private_bcb_map_object_type=0;

	if (!captive_private_bcb_map_object_type) {
static const GTypeInfo captive_private_bcb_map_object_info={
				sizeof(CaptivePrivateBcbMapObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_private_bcb_map_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptivePrivateBcbMapObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_private_bcb_map_object_init,
				};

		captive_private_bcb_map_object_type=g_type_register_static(CAPTIVE_PRIVATE_BCB_TYPE_OBJECT,
				"CaptivePrivateBcbMapObject",&captive_private_bcb_map_object_info,0);
		}

	return captive_private_bcb_map_object_type;
}

CaptivePrivateBcbMapObject *captive_private_bcb_map_object_new(CaptiveSharedCacheMapObject *captive_shared_cache_map_object)
{
CaptivePrivateBcbMapObject *captive_private_bcb_map_object;

	g_return_val_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object),NULL);

	captive_private_bcb_map_object=g_object_new(
			CAPTIVE_PRIVATE_BCB_MAP_TYPE_OBJECT,	/* object_type */
			NULL);	/* first_property_name; FIXME: support properties */

	_captive_private_bcb_object_connect_SharedCacheMap(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_map_object),
			captive_shared_cache_map_object);

	g_assert(captive_shared_cache_map_object->map==NULL);
	captive_shared_cache_map_object->map=captive_private_bcb_map_object;
	g_object_ref(captive_shared_cache_map_object);	/* 'map' connected. */

	return captive_private_bcb_map_object;
}

CaptivePrivateBcbMapObject *captive_private_bcb_map_object_get_ref
		(CaptiveSharedCacheMapObject *captive_shared_cache_map_object)
{
	g_return_val_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object),NULL);

	if (captive_shared_cache_map_object->map) {
		g_object_ref(captive_shared_cache_map_object->map);
		return captive_shared_cache_map_object->map;
		}
	return captive_private_bcb_map_object_new(captive_shared_cache_map_object);
}
