/* $Id: privatebcbpin.c,v 1.7 2003/10/15 18:59:35 short Exp $
 * reactos Cache Manager (Cc*) PrivateBcb Map type structure of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "privatebcbpin.h"	/* self */
#include "privatebcb.h"
#include "privatebcb-priv.h"
#include "sharedcachemap-priv.h"
#include <glib-object.h>
#include "captive/macros.h"


struct _CaptivePrivateBcbPinObject {
	CaptivePrivateBcbObject parent_instance;

	gulong FileSizes_changed_handler_id;
	gulong FileSizes_changed_after_handler_id;
	gulong purge_handler_id;
	guint64 offset;
	};
struct _CaptivePrivateBcbPinObjectClass {
	CaptivePrivateBcbObjectClass parent_class;
	};


static gpointer captive_private_bcb_pin_object_parent_class=NULL;


static void captive_private_bcb_pin_object_finalize(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object)
{
CaptivePrivateBcbObject *captive_private_bcb_object;
CaptiveSharedCacheMapObject *SharedCacheMap;
GHashTable *pin_hash;

	g_return_if_fail(captive_private_bcb_pin_object!=NULL);

	captive_private_bcb_object=CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object);

	if (captive_private_bcb_pin_object->FileSizes_changed_handler_id) {
		g_assert(captive_private_bcb_object->SharedCacheMap!=NULL);
		g_signal_handler_disconnect(
				captive_private_bcb_object->SharedCacheMap,	/* instance */
				captive_private_bcb_pin_object->FileSizes_changed_handler_id);
		captive_private_bcb_pin_object->FileSizes_changed_handler_id=0;
		}
	if (captive_private_bcb_pin_object->FileSizes_changed_after_handler_id) {
		g_assert(captive_private_bcb_object->SharedCacheMap!=NULL);
		g_signal_handler_disconnect(
				captive_private_bcb_object->SharedCacheMap,	/* instance */
				captive_private_bcb_pin_object->FileSizes_changed_after_handler_id);
		captive_private_bcb_pin_object->FileSizes_changed_after_handler_id=0;
		}
	if (captive_private_bcb_pin_object->purge_handler_id) {
		g_assert(captive_private_bcb_object->SharedCacheMap!=NULL);
		g_signal_handler_disconnect(
				captive_private_bcb_object->SharedCacheMap,	/* instance */
				captive_private_bcb_pin_object->purge_handler_id);
		captive_private_bcb_pin_object->purge_handler_id=0;
		}
	if ((SharedCacheMap=captive_private_bcb_object->SharedCacheMap)) {
		if ((pin_hash=SharedCacheMap->pin_hash)) {
			/* Do not: g_assert(g_hash_table_lookup(pin_hash,&captive_private_bcb_object->offset));
			 * as we may be captive_private_bcb_pin_object_detach_pin()ed.
			 */
			if (captive_private_bcb_object==g_hash_table_lookup(pin_hash,&captive_private_bcb_pin_object->offset))
				g_hash_table_remove(pin_hash,&captive_private_bcb_pin_object->offset);
			}
		}

	G_OBJECT_CLASS(captive_private_bcb_pin_object_parent_class)->finalize((GObject *)captive_private_bcb_pin_object);
}


static void captive_private_bcb_pin_object_class_init(CaptivePrivateBcbPinObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_private_bcb_pin_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_private_bcb_pin_object_finalize;
}

static void captive_private_bcb_pin_object_init(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object)
{
}

GType captive_private_bcb_pin_object_get_type(void)
{
static GType captive_private_bcb_pin_object_type=0;

	if (!captive_private_bcb_pin_object_type) {
static const GTypeInfo captive_private_bcb_pin_object_info={
				sizeof(CaptivePrivateBcbPinObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_private_bcb_pin_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptivePrivateBcbPinObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_private_bcb_pin_object_init,
				};

		captive_private_bcb_pin_object_type=g_type_register_static(CAPTIVE_PRIVATE_BCB_TYPE_OBJECT,
				"CaptivePrivateBcbPinObject",&captive_private_bcb_pin_object_info,0);
		}

	return captive_private_bcb_pin_object_type;
}


static guint captive_private_bcb_pin_object_hash_new_hash_func(const guint64 *offsetp)
{
	return (*offsetp)^((*offsetp)>>32);
}

static gboolean captive_private_bcb_pin_object_hash_new_key_compare_func(const guint64 *offset_ap,const guint64 *offset_bp)
{
	return (*offset_ap)==(*offset_bp);
}

GHashTable *captive_private_bcb_pin_object_hash_new(void)
{
	return g_hash_table_new(
			(GHashFunc)captive_private_bcb_pin_object_hash_new_hash_func,
			(GEqualFunc)captive_private_bcb_pin_object_hash_new_key_compare_func);
}

void captive_private_bcb_pin_object_hash_destroy(GHashTable *pin_hash)
{
	g_return_if_fail(pin_hash!=NULL);

	g_hash_table_destroy(pin_hash);
}

static void captive_private_bcb_pin_object_validate(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object)
{
guint64 start,end;

	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(
			CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap));

	start=captive_private_bcb_pin_object->offset;
	end  =captive_private_bcb_pin_object->offset+PAGE_SIZE;

	g_assert(end<=CAPTIVE_ROUND_UP64(
			CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap->AllocationSize,PAGE_SIZE));
}

static void captive_private_bcb_pin_object_FileSizes_changed(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 AllocationSize,guint64 FileSize,guint64 ValidDataLength,
		CaptivePrivateBcbPinObject *captive_private_bcb_pin_object /* user_data */)
{
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object));
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap
			==captive_shared_cache_map_object);

	/* ntfs.sys of NT-5.1sp1 may extend StreamFileObject while dirty pins exist.
	 * How to extend SharedCacheMap size without changing the memory location?
	 * I hope ntfs.sys does not expect long-term absolute position of its
	 * StreamFileObject:
	 */
	if (!(captive_shared_cache_map_object->FileObject->Flags&FO_STREAM_FILE)) {
		/* 'AllocationSize' must not change if any map/pin Bcbs exist. */
		g_assert(AllocationSize==captive_shared_cache_map_object->AllocationSize);
		}
}

static void captive_private_bcb_pin_object_purge(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		CaptivePrivateBcbPinObject *captive_private_bcb_pin_object /* user_data */)
{
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object));
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap
			==captive_shared_cache_map_object);

	g_assert(!captive_shared_cache_map_is_page_dirty(captive_shared_cache_map_object,
			captive_private_bcb_pin_object->offset));
}

static void captive_private_bcb_pin_object_FileSizes_changed_after(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 AllocationSize,guint64 FileSize,guint64 ValidDataLength,
		CaptivePrivateBcbPinObject *captive_private_bcb_pin_object /* user_data */)
{
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object));
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap
			==captive_shared_cache_map_object);

	/* we are 'g_signal_connect_after' */
	g_assert(AllocationSize ==captive_shared_cache_map_object->AllocationSize);
	g_assert(FileSize       ==captive_shared_cache_map_object->FileSize);
	g_assert(ValidDataLength==captive_shared_cache_map_object->ValidDataLength);

	captive_private_bcb_pin_object_validate(captive_private_bcb_pin_object);
}

void _captive_private_bcb_pin_object_connect_SharedCacheMap
		(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object,CaptiveSharedCacheMapObject *captive_shared_cache_map_object)
{
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object));
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap==NULL);

	_captive_private_bcb_object_connect_SharedCacheMap(
			CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object),captive_shared_cache_map_object);

	captive_private_bcb_pin_object->FileSizes_changed_handler_id=g_signal_connect(
			captive_shared_cache_map_object,"FileSizes_changed",
			G_CALLBACK(captive_private_bcb_pin_object_FileSizes_changed),
			captive_private_bcb_pin_object);
	g_assert(captive_private_bcb_pin_object->FileSizes_changed_handler_id>=1);
	captive_private_bcb_pin_object->FileSizes_changed_after_handler_id=g_signal_connect_after(
			captive_shared_cache_map_object,"FileSizes_changed",
			G_CALLBACK(captive_private_bcb_pin_object_FileSizes_changed_after),
			captive_private_bcb_pin_object);
	g_assert(captive_private_bcb_pin_object->FileSizes_changed_after_handler_id>=1);
	captive_private_bcb_pin_object->purge_handler_id=g_signal_connect(
			captive_shared_cache_map_object,"purge",
			G_CALLBACK(captive_private_bcb_pin_object_purge),
			captive_private_bcb_pin_object);
	g_assert(captive_private_bcb_pin_object->purge_handler_id>=1);
}

CaptivePrivateBcbPinObject *captive_private_bcb_pin_object_new(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset)
{
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object;

	g_return_val_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object),NULL);
	g_return_val_if_fail(0==CAPTIVE_ROUND_DOWN_EXCEEDING64(offset,PAGE_SIZE),NULL);

	g_assert(captive_shared_cache_map_object->PinAccess);

	captive_private_bcb_pin_object=g_object_new(
			CAPTIVE_PRIVATE_BCB_PIN_TYPE_OBJECT,	/* object_type */
			NULL);	/* first_property_name; FIXME: support properties */

	captive_private_bcb_pin_object->offset=offset;

	_captive_private_bcb_pin_object_connect_SharedCacheMap(captive_private_bcb_pin_object,
			captive_shared_cache_map_object);

	g_assert(captive_shared_cache_map_object->pin_hash!=NULL);
	g_assert(!g_hash_table_lookup(captive_shared_cache_map_object->pin_hash,
			&captive_private_bcb_pin_object->offset));
	g_hash_table_insert(captive_shared_cache_map_object->pin_hash,
			&captive_private_bcb_pin_object->offset,
			captive_private_bcb_pin_object);

	return captive_private_bcb_pin_object;
}

CaptivePrivateBcbPinObject *captive_private_bcb_pin_object_get(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset)
{
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object;

	g_return_val_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object),NULL);
	g_return_val_if_fail(0==CAPTIVE_ROUND_DOWN_EXCEEDING64(offset,PAGE_SIZE),NULL);

	if ((captive_private_bcb_pin_object=g_hash_table_lookup(captive_shared_cache_map_object->pin_hash,
			&offset))) {
		g_assert(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
		return captive_private_bcb_pin_object;
		}
	return NULL;
}

CaptivePrivateBcbPinObject *captive_private_bcb_pin_object_get_ref(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset,gboolean invalidate_new)
{
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object;

	g_return_val_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(captive_shared_cache_map_object),NULL);
	g_return_val_if_fail(0==CAPTIVE_ROUND_DOWN_EXCEEDING64(offset,PAGE_SIZE),NULL);

	if ((captive_private_bcb_pin_object=captive_private_bcb_pin_object_get(captive_shared_cache_map_object,offset))) {
		g_assert(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
		g_object_ref(captive_private_bcb_pin_object);
		return captive_private_bcb_pin_object;
		}

	if (invalidate_new) {
		/* Invalide possibly only 'map'ped data as we need to re-read them on CcPinRead().
		 * Otherwise any file written by fastfat.sys of NT-5.1sp1 will corrupt
		 * the code+55AA of DOS boot sector (disk offset 0x0).
		 */
		captive_shared_cache_map_flush(captive_shared_cache_map_object,
				offset,offset+PAGE_SIZE);
		captive_shared_cache_map_set_data_invalid(captive_shared_cache_map_object,
				offset,offset+PAGE_SIZE);
		}

	return captive_private_bcb_pin_object_new(captive_shared_cache_map_object,offset);
}

gboolean captive_private_bcb_pin_object_is_dirty(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object)
{
	g_return_val_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object),FALSE);
	g_return_val_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(
			CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap),FALSE);

	return captive_shared_cache_map_is_page_dirty(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap,
			captive_private_bcb_pin_object->offset);
}

void captive_private_bcb_pin_object_flush(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object)
{
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(
			CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap));
	g_return_if_fail(captive_private_bcb_pin_object_is_dirty(captive_private_bcb_pin_object));

	/* Flush synchronously here. */
	captive_shared_cache_map_flush(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap,
			captive_private_bcb_pin_object->offset,
			captive_private_bcb_pin_object->offset+PAGE_SIZE);
}

void captive_private_bcb_pin_object_set_dirty(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object)
{
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(
			CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap));

	captive_shared_cache_map_set_dirty(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap,
			captive_private_bcb_pin_object->offset,
			captive_private_bcb_pin_object->offset+PAGE_SIZE);
}

void captive_private_bcb_pin_object_set_lsn(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object,gint64 lsn)
{
	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));
	g_return_if_fail(CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(
			CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap));

	captive_shared_cache_map_page_set_lsn(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object)->SharedCacheMap,
			captive_private_bcb_pin_object->offset,lsn);
}

void captive_private_bcb_pin_object_detach_pin(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object)
{
CaptiveSharedCacheMapObject *SharedCacheMap;

	g_return_if_fail(CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(captive_private_bcb_pin_object));

	SharedCacheMap=captive_private_bcb_object_get_SharedCacheMap(CAPTIVE_PRIVATE_BCB_OBJECT(captive_private_bcb_pin_object));
	g_assert(SharedCacheMap->pin_hash!=NULL);
	g_assert(captive_private_bcb_pin_object==g_hash_table_lookup(SharedCacheMap->pin_hash,
			&captive_private_bcb_pin_object->offset));
	g_hash_table_remove(SharedCacheMap->pin_hash,&captive_private_bcb_pin_object->offset);
}
