/* $Id: privatebcbpin.h,v 1.3 2003/10/11 12:54:54 short Exp $
 * Include file for reactos Cache Manager (Cc*) PrivateBcbPin structure of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CC_PRIVATE_BCB_PIN_H
#define _CAPTIVE_CC_PRIVATE_BCB_PIN_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include "sharedcachemap.h"


G_BEGIN_DECLS

#define CAPTIVE_PRIVATE_BCB_PIN_TYPE_OBJECT            (captive_private_bcb_pin_object_get_type())
#define CAPTIVE_PRIVATE_BCB_PIN_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_PRIVATE_BCB_PIN_TYPE_OBJECT,CaptivePrivateBcbPinObject))
#define CAPTIVE_PRIVATE_BCB_PIN_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_PRIVATE_BCB_PIN_TYPE_OBJECT,CaptivePrivateBcbPinObjectClass))
#define CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_PRIVATE_BCB_PIN_TYPE_OBJECT))
#define CAPTIVE_PRIVATE_BCB_PIN_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_PRIVATE_BCB_PIN_TYPE_OBJECT))
#define CAPTIVE_PRIVATE_BCB_PIN_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_PRIVATE_BCB_PIN_TYPE_OBJECT,CaptivePrivateBcbPinObjectClass))
typedef struct _CaptivePrivateBcbPinObject      CaptivePrivateBcbPinObject;
typedef struct _CaptivePrivateBcbPinObjectClass CaptivePrivateBcbPinObjectClass;


GType captive_private_bcb_pin_object_get_type(void);

GHashTable *captive_private_bcb_pin_object_hash_new(void);
void captive_private_bcb_pin_object_hash_destroy(GHashTable *pin_hash);
void _captive_private_bcb_pin_object_connect_SharedCacheMap
		(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object,CaptiveSharedCacheMapObject *SharedCacheMap);
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object_new(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset);
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object_get(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset);
CaptivePrivateBcbPinObject *captive_private_bcb_pin_object_get_ref(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset,gboolean invalidate_new);
gboolean captive_private_bcb_pin_object_is_dirty(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object);
void captive_private_bcb_pin_object_flush(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object);
void captive_private_bcb_pin_object_set_dirty(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object);
void captive_private_bcb_pin_object_set_lsn(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object,gint64 lsn);
void captive_private_bcb_pin_object_detach_pin(CaptivePrivateBcbPinObject *captive_private_bcb_pin_object);

G_END_DECLS


#endif /* _CAPTIVE_CC_PRIVATE_BCB_PIN_H */
