/* $Id: sharedcachemap-priv.h,v 1.6 2003/11/28 22:03:45 short Exp $
 * Object-private include file for reactos Cache Manager (Cc*) SharedCacheMap structure of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CC_SHARED_CACHE_MAP_PRIV_H
#define _CAPTIVE_CC_SHARED_CACHE_MAP_PRIV_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include "reactos/ddk/cctypes.h"
#include "privatebcbmap.h"


G_BEGIN_DECLS

typedef struct _CaptiveSharedCacheMapObject_page CaptiveSharedCacheMapObject_page;

struct _CaptiveSharedCacheMapObject_page {
	gboolean data_valid;
	gboolean dirty;
	gint64 lsn_oldest,lsn_newest;
	};

struct _CaptiveSharedCacheMapObject {
	GObject parent_instance;

	gint w32_ref_count;
	FILE_OBJECT *FileObject;
	SECTION_OBJECT_POINTERS *SectionObjectPointer;
	/* ValidDataLength<=FileSize<=AllocationSize */
	/* 'AllocationSize' sets the mmap(2)ed area of buffers of this SharedCacheMap.
	 * We must reallocate this area if 'AllocationSize' changes and in such case
	 * there must exist no map-Bcb or pin-Bcbs for it.
	 * We would cope with 'buffer' change with existing Bcbs but W32 client could not.
	 */
	guint64 AllocationSize;	/* ==CC_FILE_SIZES.AllocationSize.QuadPart */
	/* We generally check against CAPTIVE_ROUND_UP64(FileSize,PAGE_SIZE)
	 * as the offsets are usually PAGE_SIZE aligned due to pin-Bcb expectations.
	 */
	guint64 FileSize;	/* ==CC_FILE_SIZES.FileSize.QuadPart */
	/* We use do not use 'ValidDataLength' as I assume W32
	 * automatically increases 'ValidDataLength' during Cache Manager write operations.
	 * We do not increase it and therefore it is mostly useless for us.
	 * In some cases (during NTFS mount) there may be also invalid 'ValidDataLength' at all:
	 * 	CcSetFileSizes(AllocationSize=0x1000000,FileSize=0xf80208,ValidDataLength=0x23b801a0)
	 */
	guint64 ValidDataLength;	/* ==CC_FILE_SIZES.ValidDataLength.QuadPart */
	/* The real allocation size of 'buffer' and 'pages'.
	 * Maintained by captive_shared_cache_map_object_FileSizes_changed()
	 * to prevent continous reallocation to (n+1) size.
	 * We use (n*2) sizes for logaritmic time complexity.
	 */
	guint64 alloc_length;
	CACHE_MANAGER_CALLBACKS CallBacks;
	VOID *LazyWriterContext;
	gboolean PinAccess;
	CaptivePrivateBcbMapObject *map;	/* 'map' will g_object_ref(CaptiveSharedCacheMapObject). */
	GHashTable *pin_hash;	/* map: (guint64 *) -> (CaptivePrivateBcbPinObject *) */
	gboolean LogHandle_set;
	gboolean FlushToLsnRoutine_set;

	gpointer buffer;	/* FileOffset 0 based */
	CaptiveSharedCacheMapObject_page *pages;	/* FileOffset 0 based, item corresponds to 'buffer' PAGE_SIZE */
	};
struct _CaptiveSharedCacheMapObjectClass {
	GObjectClass parent_class;

	void (*FileSizes_changed)(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
			guint64 AllocationSize,guint64 FileSize,guint64 ValidDataLength);
	void (*purge)(CaptiveSharedCacheMapObject *captive_shared_cache_map_object);
	};

G_END_DECLS


#endif /* _CAPTIVE_CC_SHARED_CACHE_MAP_PRIV_H */
