/* $Id: sharedcachemap.h,v 1.7 2005/12/26 07:11:39 lace Exp $
 * Include file for reactos Cache Manager (Cc*) SharedCacheMap structure of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CC_SHARED_CACHE_MAP_H
#define _CAPTIVE_CC_SHARED_CACHE_MAP_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include "reactos/ddk/cctypes.h"


G_BEGIN_DECLS

#define CAPTIVE_SHARED_CACHE_MAP_TYPE_OBJECT            (captive_shared_cache_map_object_get_type())
#define CAPTIVE_SHARED_CACHE_MAP_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_SHARED_CACHE_MAP_TYPE_OBJECT,CaptiveSharedCacheMapObject))
#define CAPTIVE_SHARED_CACHE_MAP_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_SHARED_CACHE_MAP_TYPE_OBJECT,CaptiveSharedCacheMapObjectClass))
#define CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_SHARED_CACHE_MAP_TYPE_OBJECT))
#define CAPTIVE_SHARED_CACHE_MAP_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_SHARED_CACHE_MAP_TYPE_OBJECT))
#define CAPTIVE_SHARED_CACHE_MAP_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_SHARED_CACHE_MAP_TYPE_OBJECT,CaptiveSharedCacheMapObjectClass))
typedef struct _CaptiveSharedCacheMapObject      CaptiveSharedCacheMapObject;
typedef struct _CaptiveSharedCacheMapObjectClass CaptiveSharedCacheMapObjectClass;


GType captive_shared_cache_map_object_get_type(void);

CaptiveSharedCacheMapObject *captive_shared_cache_map_get_ref(FILE_OBJECT *FileObject,
		const CC_FILE_SIZES *FileSizes,BOOLEAN PinAccess,const CACHE_MANAGER_CALLBACKS *CallBacks,VOID *LazyWriterContext);
void captive_shared_cache_map_FileSizes_set(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		const CC_FILE_SIZES *FileSizes);
CaptiveSharedCacheMapObject *captive_SectionObjectPointers_to_SharedCacheMap(SECTION_OBJECT_POINTERS *SectionObjectPointers);
CaptiveSharedCacheMapObject *captive_FileObject_to_SharedCacheMap(FILE_OBJECT *FileObject);
void captive_shared_cache_map_w32_ref(CaptiveSharedCacheMapObject *captive_shared_cache_map_object);
void captive_shared_cache_map_w32_unref(CaptiveSharedCacheMapObject *captive_shared_cache_map_object);
gint captive_shared_cache_map_query_w32_ref(CaptiveSharedCacheMapObject *captive_shared_cache_map_object);
void captive_shared_cache_map_data_validate_read(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		FILE_OBJECT *FileObject,guint64 validate_start,guint64 validate_end);
void captive_shared_cache_map_data_validate_noread(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 validate_start,guint64 validate_end);
void captive_shared_cache_map_set_data_valid(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 start,guint64 end);
void captive_shared_cache_map_set_data_invalid(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 start,guint64 end);
void captive_shared_cache_map_set_dirty(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 start,guint64 end);
guint64 captive_shared_cache_map_memory_range_set_dirty(gpointer address_start,gpointer address_end);
gboolean captive_shared_cache_map_is_page_dirty(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset);
void captive_shared_cache_map_page_set_lsn(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 offset,gint64 lsn);
void captive_shared_cache_map_purge(CaptiveSharedCacheMapObject *captive_shared_cache_map_object);
void captive_shared_cache_map_set_LogHandle(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,VOID *LogHandle);
void captive_shared_cache_map_set_FlushToLsnRoutine
		(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,PFLUSH_TO_LSN FlushToLsnRoutine);
guint64 captive_shared_cache_map_flush(CaptiveSharedCacheMapObject *captive_shared_cache_map_object,
		guint64 start,guint64 end);
void captive_shared_cache_map_flush_all(void);
gboolean captive_shared_cache_map_is_any_dirty(void);
gint64 captive_shared_cache_map_CcGetDirtyPages(PDIRTY_PAGE_ROUTINE DirtyPageRoutine,VOID *Context1,VOID *Context2);
gpointer captive_shared_cache_map_get_buffer(CaptiveSharedCacheMapObject *captive_shared_cache_map_object);
gboolean captive_shared_cache_map_restart_needed(void);

G_END_DECLS


#endif /* _CAPTIVE_CC_SHARED_CACHE_MAP_H */
