/* $Id: directory-parent.c,v 1.4 2006/01/01 07:24:34 lace Exp $
 * captive vfs 'directory' interface to reactos of sandbox parent
 * Copyright (C) 2002-2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "directory-parent.h"	/* self */
#include <glib/gmessages.h>
#include "../sandbox/parent-Directory.h"
#include "vfs-parent.h"
#include "parent-connector.h"


static gpointer captive_directory_parent_object_parent_class=NULL;


static GnomeVFSResult captive_directory_parent_close(CaptiveDirectoryObject *captive_directory_object);
static GnomeVFSResult captive_directory_parent_read
		(CaptiveDirectoryObject *captive_directory_object,CaptiveFileInfoObject **captive_file_info_object_return);
static GnomeVFSResult captive_directory_parent_remove(CaptiveDirectoryObject *captive_directory_object);


static void captive_directory_parent_object_dispose(CaptiveDirectoryParentObject *captive_directory_parent_object)
{
	g_return_if_fail(captive_directory_parent_object!=NULL);

	captive_directory_parent_close(CAPTIVE_DIRECTORY_OBJECT(captive_directory_parent_object));	/* errors ignored */

	if (captive_parent_connector_dispose(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object)))
		return;

	G_OBJECT_CLASS(captive_directory_parent_object_parent_class)->dispose((GObject *)captive_directory_parent_object);
}

static void captive_directory_parent_object_finalize(CaptiveDirectoryParentObject *captive_directory_parent_object)
{
	g_return_if_fail(captive_directory_parent_object!=NULL);

	captive_parent_connector_finalize(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object));

	g_free(captive_directory_parent_object->pathname);
	captive_directory_parent_object->pathname=NULL;

	G_OBJECT_CLASS(captive_directory_parent_object_parent_class)->finalize((GObject *)captive_directory_parent_object);
}

static void captive_directory_parent_object_class_init(CaptiveDirectoryParentObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);
CaptiveDirectoryObjectClass *captive_directory_object_class=CAPTIVE_DIRECTORY_OBJECT_CLASS(class);

	captive_directory_parent_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->dispose=(void (*)(GObject *object))captive_directory_parent_object_dispose;
	gobject_class->finalize=(void (*)(GObject *object))captive_directory_parent_object_finalize;

	captive_directory_object_class->read=captive_directory_parent_read;
	captive_directory_object_class->remove=captive_directory_parent_remove;
}


static GnomeVFSResult (*captive_directory_parent_object_captive_parent_connector_open_orig)
		(CaptiveParentConnector *captive_parent_connector);
static GnomeVFSResult captive_directory_parent_object_captive_parent_connector_open
		(CaptiveParentConnector *captive_parent_connector);

static GnomeVFSResult captive_directory_parent_object_captive_parent_connector_close
		(CaptiveParentConnector *captive_parent_connector);
static GnomeVFSResult (*captive_directory_parent_object_captive_parent_connector_close_orig)
		(CaptiveParentConnector *captive_parent_connector);

static G_CONST_RETURN gchar *captive_directory_parent_object_captive_parent_connector_get_pathname
		(CaptiveParentConnector *captive_parent_connector);

static void captive_directory_parent_object_captive_parent_connector_init(CaptiveParentConnectorIface *captive_parent_connector_iface)
{
	g_return_if_fail(CAPTIVE_IS_PARENT_CONNECTOR_CLASS(captive_parent_connector_iface));

	captive_directory_parent_object_captive_parent_connector_open_orig=captive_parent_connector_iface->open;
	captive_parent_connector_iface->open=captive_directory_parent_object_captive_parent_connector_open;

	captive_directory_parent_object_captive_parent_connector_close_orig=captive_parent_connector_iface->close;
	captive_parent_connector_iface->close=captive_directory_parent_object_captive_parent_connector_close;

	captive_parent_connector_iface->get_pathname=captive_directory_parent_object_captive_parent_connector_get_pathname;
}


static void captive_directory_parent_object_init(CaptiveDirectoryParentObject *captive_directory_parent_object)
{
	g_return_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_directory_parent_object));
}


GType captive_directory_parent_object_get_type(void)
{
static GType captive_directory_parent_object_type=0;

	if (!captive_directory_parent_object_type) {
static const GTypeInfo captive_directory_parent_object_info={
				sizeof(CaptiveDirectoryParentObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_directory_parent_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptiveDirectoryParentObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_directory_parent_object_init,
				};
static const GInterfaceInfo captive_parent_connector_info={
				(GInterfaceInitFunc)captive_directory_parent_object_captive_parent_connector_init,	/* interface_init */
				NULL,	/* interface_finalize */
				NULL,	/* interface_data */
				};

		captive_directory_parent_object_type=g_type_register_static(CAPTIVE_DIRECTORY_TYPE_OBJECT,
				"CaptiveDirectoryParentObject",&captive_directory_parent_object_info,0);
		g_type_add_interface_static(captive_directory_parent_object_type,
				CAPTIVE_TYPE_PARENT_CONNECTOR,&captive_parent_connector_info);
		}

	return captive_directory_parent_object_type;
}


static void captive_directory_parent_init
		(CaptiveDirectoryParentObject *captive_directory_parent_object,CaptiveVfsObject *captive_vfs_object)
{
	g_return_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_directory_parent_object));
	g_return_if_fail(CAPTIVE_VFS_PARENT_IS_OBJECT(captive_vfs_object));

	/* Order of captive_directory_init() and captive_parent_connector_init()
	 * should not matter as 'vfs' is passed by value to captive_parent_connector_init().
	 */
	captive_directory_init(CAPTIVE_DIRECTORY_OBJECT(captive_directory_parent_object),captive_vfs_object);

	captive_parent_connector_init(
			CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object),	/* captive_parent_connector */
			&captive_directory_parent_object->corba_Directory_object,	/* corba_objectp */
			CAPTIVE_VFS_PARENT_OBJECT(CAPTIVE_DIRECTORY_OBJECT(captive_directory_parent_object)->vfs));	/* captive_vfs_parent_object */
}

GnomeVFSResult captive_directory_parent_new_open(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname)
{
CaptiveDirectoryParentObject *captive_directory_parent_object;
GnomeVFSResult r;

	g_return_val_if_fail(captive_directory_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_PARENT_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_directory_parent_object=g_object_new(
			CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT,	/* object_type */
			NULL);	/* first_property_name; FIXME: support properties */
	captive_directory_parent_object->pathname=g_strdup(pathname);

	captive_directory_parent_init(captive_directory_parent_object,captive_vfs_object);

	if (GNOME_VFS_OK!=(r=captive_parent_connector_connect(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object))))
		return r;

	if (GNOME_VFS_OK!=(r=captive_sandbox_parent_directory_new_open(captive_directory_parent_object))) {
		g_object_unref(captive_directory_parent_object);
		*captive_directory_object_return=NULL;
		return r;
		}

	*captive_directory_object_return=CAPTIVE_DIRECTORY_OBJECT(captive_directory_parent_object);
	return (*captive_directory_parent_object_captive_parent_connector_open_orig)
			(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object));
}


GnomeVFSResult captive_directory_parent_new_make(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,guint perm)
{
CaptiveDirectoryParentObject *captive_directory_parent_object;
GnomeVFSResult r;

	g_return_val_if_fail(captive_directory_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_PARENT_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_directory_parent_object=g_object_new(
			CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT,	/* object_type */
			NULL);	/* first_property_name; FIXME: support properties */
	captive_directory_parent_object->pathname=g_strdup(pathname);

	captive_directory_parent_init(captive_directory_parent_object,captive_vfs_object);

	if (GNOME_VFS_OK!=(r=captive_parent_connector_connect(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object))))
		return r;

	if (GNOME_VFS_OK!=(r=captive_sandbox_parent_directory_new_make(captive_directory_parent_object,perm))) {
		g_object_unref(captive_directory_parent_object);
		*captive_directory_object_return=NULL;
		return r;
		}
	captive_parent_connector_set_dirty(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object));

	*captive_directory_object_return=CAPTIVE_DIRECTORY_OBJECT(captive_directory_parent_object);
	return (*captive_directory_parent_object_captive_parent_connector_open_orig)
			(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object));
}


static GnomeVFSResult captive_directory_parent_close(CaptiveDirectoryObject *captive_directory_object)
{
CaptiveDirectoryParentObject *captive_directory_parent_object;
GnomeVFSResult r;
gint retried=0;

	g_return_val_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_directory_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_directory_parent_object=CAPTIVE_DIRECTORY_PARENT_OBJECT(captive_directory_object);

	do {
		if (GNOME_VFS_OK!=(r=captive_parent_connector_open(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object))))
			break;
		if (GNOME_VFS_ERROR_SERVICE_NOT_AVAILABLE
				!=(r=captive_parent_connector_close(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object))))
			break;
		} while (!retried++);
	return r;
}


static GnomeVFSResult captive_directory_parent_object_captive_parent_connector_open
		(CaptiveParentConnector *captive_parent_connector)
{
GnomeVFSResult r;

	g_return_val_if_fail(CAPTIVE_IS_PARENT_CONNECTOR(captive_parent_connector),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_parent_connector),GNOME_VFS_ERROR_BAD_PARAMETERS);

	if (GNOME_VFS_OK!=(r=captive_sandbox_parent_directory_new_open(CAPTIVE_DIRECTORY_PARENT_OBJECT(captive_parent_connector))))
		return r;

	return (*captive_directory_parent_object_captive_parent_connector_open_orig)(captive_parent_connector);
}


static GnomeVFSResult captive_directory_parent_object_captive_parent_connector_close
		(CaptiveParentConnector *captive_parent_connector)
{
GnomeVFSResult r;

	g_return_val_if_fail(CAPTIVE_IS_PARENT_CONNECTOR(captive_parent_connector),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_parent_connector),GNOME_VFS_ERROR_BAD_PARAMETERS);

	if (GNOME_VFS_OK!=(r=captive_sandbox_parent_directory_close(CAPTIVE_DIRECTORY_PARENT_OBJECT(captive_parent_connector))))
		return r;

	return (*captive_directory_parent_object_captive_parent_connector_close_orig)(captive_parent_connector);
}


static G_CONST_RETURN gchar *captive_directory_parent_object_captive_parent_connector_get_pathname
		(CaptiveParentConnector *captive_parent_connector)
{
CaptiveDirectoryParentObject *captive_directory_parent_object;

	g_return_val_if_fail(CAPTIVE_IS_PARENT_CONNECTOR(captive_parent_connector),NULL);
	g_return_val_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_parent_connector),NULL);

	captive_directory_parent_object=CAPTIVE_DIRECTORY_PARENT_OBJECT(captive_parent_connector);

	g_return_val_if_fail(captive_directory_parent_object->pathname!=NULL,NULL);

	return captive_directory_parent_object->pathname;
}


static GnomeVFSResult captive_directory_parent_read
		(CaptiveDirectoryObject *captive_directory_object,CaptiveFileInfoObject **captive_file_info_object_return)
{
CaptiveDirectoryParentObject *captive_directory_parent_object;
GnomeVFSResult r;
gint retried=0;

	g_return_val_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_directory_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(captive_file_info_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_directory_parent_object=CAPTIVE_DIRECTORY_PARENT_OBJECT(captive_directory_object);

	do {
		if (GNOME_VFS_OK!=(r=captive_parent_connector_open(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object))))
			return r;
		if (GNOME_VFS_ERROR_SERVICE_NOT_AVAILABLE
				!=(r=captive_sandbox_parent_directory_read(captive_directory_parent_object,captive_file_info_object_return)))
			return r;
		} while (!retried++);
	return r;
}


static GnomeVFSResult captive_directory_parent_remove(CaptiveDirectoryObject *captive_directory_object)
{
CaptiveDirectoryParentObject *captive_directory_parent_object;
GnomeVFSResult r;
gint retried=0;

	g_return_val_if_fail(CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(captive_directory_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_directory_parent_object=CAPTIVE_DIRECTORY_PARENT_OBJECT(captive_directory_object);

	do {
		if (GNOME_VFS_OK!=(r=captive_parent_connector_open(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object))))
			return r;
		if (GNOME_VFS_ERROR_SERVICE_NOT_AVAILABLE!=(r=captive_sandbox_parent_directory_remove(captive_directory_parent_object))) {
			if (GNOME_VFS_OK==r)
				captive_parent_connector_set_dirty(CAPTIVE_PARENT_CONNECTOR(captive_directory_parent_object));
			return r;
			}
		} while (!retried++);
	return r;
}
