/* $Id: directory-parent.h,v 1.2 2003/09/12 07:15:14 short Exp $
 * Include file for captive vfs 'directory' private interface to reactos of sandbox parent
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_DIRECTORY_PARENT_H
#define _CAPTIVE_CLIENT_PRIV_DIRECTORY_PARENT_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include <glib/glist.h>
#include "captive/client-directory.h"	/* for CaptiveDirectoryObject */
#include "directory.h"	/* for CaptiveDirectoryObject priv */
#include "../sandbox/sandbox.h"


G_BEGIN_DECLS

#define CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT            (captive_directory_parent_object_get_type())
#define CAPTIVE_DIRECTORY_PARENT_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT,CaptiveDirectoryParentObject))
#define CAPTIVE_DIRECTORY_PARENT_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT,CaptiveDirectoryParentObjectClass))
#define CAPTIVE_DIRECTORY_PARENT_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT))
#define CAPTIVE_DIRECTORY_PARENT_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT))
#define CAPTIVE_DIRECTORY_PARENT_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_DIRECTORY_PARENT_TYPE_OBJECT,CaptiveDirectoryParentObjectClass))
typedef struct _CaptiveDirectoryParentObject      CaptiveDirectoryParentObject;
typedef struct _CaptiveDirectoryParentObjectClass CaptiveDirectoryParentObjectClass;


GType captive_directory_parent_object_get_type(void);

struct _CaptiveDirectoryParentObject {
	CaptiveDirectoryObject parent_instance;

	/*< private >*/
	Captive_Directory corba_Directory_object;
	GList *corba_Directory_file_info_list;	/* contents */
	gchar *pathname;
	};
struct _CaptiveDirectoryParentObjectClass {
	CaptiveDirectoryObjectClass parent_class;
	};

GnomeVFSResult captive_directory_parent_new_open(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname);
GnomeVFSResult captive_directory_parent_new_make(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,guint perm);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_DIRECTORY_PARENT_H */
