/* $Id: directory-slave.h,v 1.1 2003/09/09 17:27:28 short Exp $
 * Include file for captive vfs 'directory' private interface to reactos of sandbox slave
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_DIRECTORY_SLAVE_H
#define _CAPTIVE_CLIENT_PRIV_DIRECTORY_SLAVE_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include "captive/client-directory.h"	/* for CaptiveDirectoryObject */
#include "directory.h"	/* for CaptiveDirectoryObject priv */
#include "reactos/ntos/types.h"	/* for HANDLE */
#include "reactos/ntos/zwtypes.h"	/* for FILE_ID_BOTH_DIR_INFORMATION */


G_BEGIN_DECLS

#define CAPTIVE_DIRECTORY_SLAVE_TYPE_OBJECT            (captive_directory_slave_object_get_type())
#define CAPTIVE_DIRECTORY_SLAVE_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_DIRECTORY_SLAVE_TYPE_OBJECT,CaptiveDirectorySlaveObject))
#define CAPTIVE_DIRECTORY_SLAVE_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_DIRECTORY_SLAVE_TYPE_OBJECT,CaptiveDirectorySlaveObjectClass))
#define CAPTIVE_DIRECTORY_SLAVE_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_DIRECTORY_SLAVE_TYPE_OBJECT))
#define CAPTIVE_DIRECTORY_SLAVE_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_DIRECTORY_SLAVE_TYPE_OBJECT))
#define CAPTIVE_DIRECTORY_SLAVE_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_DIRECTORY_SLAVE_TYPE_OBJECT,CaptiveDirectorySlaveObjectClass))
typedef struct _CaptiveDirectorySlaveObject      CaptiveDirectorySlaveObject;
typedef struct _CaptiveDirectorySlaveObjectClass CaptiveDirectorySlaveObjectClass;


GType captive_directory_slave_object_get_type(void);

struct _CaptiveDirectorySlaveObject {
	CaptiveDirectoryObject parent_instance;

	/*< private >*/
	HANDLE dir_Handle;
	gboolean read_first;
	/* 'QueryDirectory_buf' for NtQueryDirectoryFile() must be persistent
	 * to keep the state if !read_first.
	 * Both types of 'QueryDirectory_buf' MUST NOT be 'union' as we convert
	 * them by copying one to other.
	 */
	struct {
		char FileIdBothDirInformation[sizeof(FILE_ID_BOTH_DIR_INFORMATION)
				+0x1000 /* max 'FileName' length, 255 should be enough */ * sizeof(WCHAR /* *FILE_ID_BOTH_DIR_INFORMATION.FileName */ )];
		char FileBothDirInformation[sizeof(FILE_BOTH_DIR_INFORMATION)
				+0x1000 /* max 'FileName' length, 255 should be enough */ * sizeof(WCHAR /* *FILE_ID_BOTH_DIR_INFORMATION.FileName */ )];
		} QueryDirectory_buf;
	enum {
		CaptiveDirectorySlaveObject_QueryDirectory_type_FileIdBothDirInformation,
		CaptiveDirectorySlaveObject_QueryDirectory_type_FileBothDirInformation,
		} CaptiveDirectorySlaveObject_QueryDirectory_type;
	};
struct _CaptiveDirectorySlaveObjectClass {
	CaptiveDirectoryObjectClass parent_class;
	};


GnomeVFSResult captive_directory_slave_new_open(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname);
GnomeVFSResult captive_directory_slave_new_make(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,guint perm);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_DIRECTORY_SLAVE_H */
