/* $Id: directory.c,v 1.17 2006/01/01 07:24:34 lace Exp $
 * captive vfs 'directory' interface to reactos
 * Copyright (C) 2002-2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/client-directory.h"	/* self */
#include "directory.h"	/* self-priv */
#include <glib/gmessages.h>
#include "vfs.h"


static gpointer captive_directory_object_parent_class=NULL;


static GnomeVFSResult captive_directory_close(CaptiveDirectoryObject *captive_directory_object);

static void captive_directory_object_finalize(CaptiveDirectoryObject *captive_directory_object)
{
	g_return_if_fail(captive_directory_object!=NULL);

	captive_directory_close(captive_directory_object);	/* errors ignored */

	G_OBJECT_CLASS(captive_directory_object_parent_class)->finalize((GObject *)captive_directory_object);
}


static void captive_directory_object_class_init(CaptiveDirectoryObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_directory_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_directory_object_finalize;
}


static void captive_directory_object_init(CaptiveDirectoryObject *captive_directory_object)
{
}


GType captive_directory_object_get_type(void)
{
static GType captive_directory_object_type=0;

	if (!captive_directory_object_type) {
static const GTypeInfo captive_directory_object_info={
				sizeof(CaptiveDirectoryObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_directory_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptiveDirectoryObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_directory_object_init,
				};

		captive_directory_object_type=g_type_register_static(G_TYPE_OBJECT,
				"CaptiveDirectoryObject",&captive_directory_object_info,G_TYPE_FLAG_ABSTRACT);
		}

	return captive_directory_object_type;
}


GnomeVFSResult captive_directory_new_open(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname)
{
	g_return_val_if_fail(captive_directory_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_VFS_OBJECT_GET_CLASS(captive_vfs_object)->directory_new_open)
			(captive_directory_object_return,captive_vfs_object,pathname);
}


GnomeVFSResult captive_directory_new_make(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,guint perm)
{
	g_return_val_if_fail(captive_directory_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_VFS_OBJECT_GET_CLASS(captive_vfs_object)->directory_new_make)
			(captive_directory_object_return,captive_vfs_object,pathname,perm);
}


GnomeVFSResult captive_directory_init(CaptiveDirectoryObject *captive_directory_object,CaptiveVfsObject *captive_vfs_object)
{
	g_return_val_if_fail(CAPTIVE_DIRECTORY_IS_OBJECT(captive_directory_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	g_return_val_if_fail(captive_directory_object->vfs==NULL,GNOME_VFS_ERROR_GENERIC);

	captive_directory_object->vfs=g_object_ref(captive_vfs_object);

	return GNOME_VFS_OK;
}


static GnomeVFSResult captive_directory_close(CaptiveDirectoryObject *captive_directory_object)
{
	g_return_val_if_fail(CAPTIVE_DIRECTORY_IS_OBJECT(captive_directory_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	if (captive_directory_object->vfs!=NULL) {
		g_assert(CAPTIVE_VFS_IS_OBJECT(captive_directory_object->vfs));
		g_object_unref(captive_directory_object->vfs);
		captive_directory_object->vfs=NULL;
		}

	return GNOME_VFS_OK;
}


CaptiveVfsObject *captive_directory_ref_vfs(CaptiveDirectoryObject *captive_directory_object)
{
	g_return_val_if_fail(CAPTIVE_DIRECTORY_IS_OBJECT(captive_directory_object),NULL);

	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_directory_object->vfs),NULL);

	return g_object_ref(captive_directory_object->vfs);
}


GnomeVFSResult captive_directory_read(CaptiveDirectoryObject *captive_directory_object,
		CaptiveFileInfoObject **captive_file_info_object_return)
{
	g_return_val_if_fail(CAPTIVE_DIRECTORY_IS_OBJECT(captive_directory_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(captive_file_info_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_DIRECTORY_OBJECT_GET_CLASS(captive_directory_object)->read)
			(captive_directory_object,captive_file_info_object_return);
}


GnomeVFSResult captive_directory_remove(CaptiveDirectoryObject *captive_directory_object)
{
	g_return_val_if_fail(CAPTIVE_DIRECTORY_IS_OBJECT(captive_directory_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_DIRECTORY_OBJECT_GET_CLASS(captive_directory_object)->remove)
			(captive_directory_object);
}
