/* $Id: directory.h,v 1.6 2006/01/01 07:24:34 lace Exp $
 * Include file for captive vfs 'directory' private interface to reactos
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_DIRECTORY_H
#define _CAPTIVE_CLIENT_PRIV_DIRECTORY_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include "captive/client-vfs.h"
#include "captive/client-directory.h"
#include "captive/client-file-info.h"


G_BEGIN_DECLS

struct _CaptiveDirectoryObject {
	GObject parent_instance;

	/*< private >*/
	CaptiveVfsObject *vfs;
	};
struct _CaptiveDirectoryObjectClass {
	GObjectClass parent_class;

	GnomeVFSResult (*read)(CaptiveDirectoryObject *captive_directory_object,
			CaptiveFileInfoObject **captive_file_info_object_return);
	GnomeVFSResult (*remove)(CaptiveDirectoryObject *captive_directory_object);
	};

GnomeVFSResult captive_directory_init(CaptiveDirectoryObject *captive_directory_object,CaptiveVfsObject *captive_vfs_object);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_DIRECTORY_H */
