/* $Id: file-info.c,v 1.1 2006/01/01 07:24:34 lace Exp $
 * captive wrapper of GnomeVFSFileInfo interface to reactos
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/client-file-info.h"	/* self */
#include <glib/gmessages.h>
#include "vfs.h"
#include "reactos/ntos/types.h"	/* for ULONG */


struct _CaptiveFileInfoObjectClass {
	GObjectClass parent_class;
	};


static gpointer captive_file_info_object_parent_class=NULL;


static void captive_file_info_object_finalize(CaptiveFileInfoObject *captive_file_info_object)
{
	g_return_if_fail(captive_file_info_object!=NULL);

	gnome_vfs_file_info_clear(&captive_file_info_object->p);

	G_OBJECT_CLASS(captive_file_info_object_parent_class)->finalize((GObject *)captive_file_info_object);
}


static void captive_file_info_object_class_init(CaptiveFileInfoObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_file_info_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_file_info_object_finalize;
}


static void captive_file_info_object_init(CaptiveFileInfoObject *captive_file_info_object)
{
}


GType captive_file_info_object_get_type(void)
{
static GType captive_file_info_object_type=0;

	if (!captive_file_info_object_type) {
static const GTypeInfo captive_file_info_object_info={
				sizeof(CaptiveFileInfoObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_file_info_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptiveFileInfoObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_file_info_object_init,
				};

		captive_file_info_object_type=g_type_register_static(G_TYPE_OBJECT,
				"CaptiveFileInfoObject",&captive_file_info_object_info,0);
		}

	return captive_file_info_object_type;
}


GnomeVFSResult captive_file_info_object_new(CaptiveFileInfoObject **captive_file_info_object_return)
{
	g_return_val_if_fail(captive_file_info_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	*captive_file_info_object_return=g_object_new(
			CAPTIVE_FILE_INFO_TYPE_OBJECT, /* object_type */
			NULL);  /* first_property_name; FIXME: support properties */
	g_assert(*captive_file_info_object_return!=NULL);

	return GNOME_VFS_OK;
}
