/* $Id: file-parent.h,v 1.3 2003/09/12 19:40:17 short Exp $
 * Include file for captive vfs 'file' private interface to reactos of sandbox parent
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_FILE_PARENT_H
#define _CAPTIVE_CLIENT_PRIV_FILE_PARENT_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include "captive/client-file.h"	/* for CaptiveFileObject */
#include "file.h"	/* for CaptiveFileObject priv */
#include "../sandbox/sandbox.h"


G_BEGIN_DECLS

#define CAPTIVE_FILE_PARENT_TYPE_OBJECT            (captive_file_parent_object_get_type())
#define CAPTIVE_FILE_PARENT_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_FILE_PARENT_TYPE_OBJECT,CaptiveFileParentObject))
#define CAPTIVE_FILE_PARENT_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_FILE_PARENT_TYPE_OBJECT,CaptiveFileParentObjectClass))
#define CAPTIVE_FILE_PARENT_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_FILE_PARENT_TYPE_OBJECT))
#define CAPTIVE_FILE_PARENT_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_FILE_PARENT_TYPE_OBJECT))
#define CAPTIVE_FILE_PARENT_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_FILE_PARENT_TYPE_OBJECT,CaptiveFileParentObjectClass))
typedef struct _CaptiveFileParentObject      CaptiveFileParentObject;
typedef struct _CaptiveFileParentObjectClass CaptiveFileParentObjectClass;


GType captive_file_parent_object_get_type(void);

struct _CaptiveFileParentObject {
	CaptiveFileObject parent_instance;

	/*< private >*/
	Captive_File corba_File_object;
	GnomeVFSFileOffset offset;
	gchar *pathname;
	GnomeVFSOpenMode mode;
	};
struct _CaptiveFileParentObjectClass {
	CaptiveFileObjectClass parent_class;
	};

GnomeVFSResult captive_file_parent_new_open(CaptiveFileObject **captive_file_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode);
GnomeVFSResult captive_file_parent_new_create(CaptiveFileObject **captive_file_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode,gboolean exclusive,guint perm);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_FILE_PARENT_H */
