/* $Id: file.c,v 1.24 2006/01/01 07:24:34 lace Exp $
 * captive vfs 'file' interface to reactos
 * Copyright (C) 2002-2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/client-file.h"	/* self */
#include "file.h"	/* self-priv */
#include <glib/gmessages.h>
#include "vfs.h"
#include "reactos/ntos/types.h"	/* for ULONG */


static gpointer captive_file_object_parent_class=NULL;


static GnomeVFSResult captive_file_close(CaptiveFileObject *captive_file_object);

static void captive_file_object_finalize(CaptiveFileObject *captive_file_object)
{
	g_return_if_fail(captive_file_object!=NULL);

	captive_file_close(captive_file_object);	/* errors ignored */

	G_OBJECT_CLASS(captive_file_object_parent_class)->finalize((GObject *)captive_file_object);
}


static void captive_file_object_class_init(CaptiveFileObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_file_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_file_object_finalize;
}


static void captive_file_object_init(CaptiveFileObject *captive_file_object)
{
}


GType captive_file_object_get_type(void)
{
static GType captive_file_object_type=0;

	if (!captive_file_object_type) {
static const GTypeInfo captive_file_object_info={
				sizeof(CaptiveFileObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_file_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptiveFileObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_file_object_init,
				};

		captive_file_object_type=g_type_register_static(G_TYPE_OBJECT,
				"CaptiveFileObject",&captive_file_object_info,G_TYPE_FLAG_ABSTRACT);
		}

	return captive_file_object_type;
}


GnomeVFSResult captive_file_new_open(CaptiveFileObject **captive_file_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode)
{
	g_return_val_if_fail(captive_file_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_VFS_OBJECT_GET_CLASS(captive_vfs_object)->file_new_open)
			(captive_file_object_return,captive_vfs_object,pathname,mode);
}


GnomeVFSResult captive_file_new_create(CaptiveFileObject **captive_file_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode,gboolean exclusive,guint perm)
{
	g_return_val_if_fail(captive_file_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_VFS_OBJECT_GET_CLASS(captive_vfs_object)->file_new_create)
			(captive_file_object_return,captive_vfs_object,pathname,mode,exclusive,perm);
}


GnomeVFSResult captive_file_init(CaptiveFileObject *captive_file_object,CaptiveVfsObject *captive_vfs_object)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	g_return_val_if_fail(captive_file_object->vfs==NULL,GNOME_VFS_ERROR_GENERIC);

	captive_file_object->vfs=g_object_ref(captive_vfs_object);

	return GNOME_VFS_OK;
}


static GnomeVFSResult captive_file_close(CaptiveFileObject *captive_file_object)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	if (captive_file_object->vfs!=NULL) {
		g_assert(CAPTIVE_VFS_IS_OBJECT(captive_file_object->vfs));
		g_object_unref(captive_file_object->vfs);
		captive_file_object->vfs=NULL;
		}

	return GNOME_VFS_OK;
}


CaptiveVfsObject *captive_file_ref_vfs(CaptiveFileObject *captive_file_object)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),NULL);

	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_file_object->vfs),NULL);

	return g_object_ref(captive_file_object->vfs);
}


GnomeVFSResult captive_file_read(CaptiveFileObject *captive_file_object,
		gpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_read_return)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(buffer!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(bytes_read_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(num_bytes==(ULONG)num_bytes,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->read)
			(captive_file_object,buffer,num_bytes,bytes_read_return);
}


GnomeVFSResult captive_file_write(CaptiveFileObject *captive_file_object,
		gconstpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_written_return)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(buffer!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(bytes_written_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(num_bytes==(ULONG)num_bytes,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->write)
			(captive_file_object,buffer,num_bytes,bytes_written_return);
}


GnomeVFSResult captive_file_seek
		(CaptiveFileObject *captive_file_object,GnomeVFSSeekPosition whence,GnomeVFSFileOffset offset)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->seek)
			(captive_file_object,whence,offset);
}


GnomeVFSResult captive_file_tell(CaptiveFileObject *captive_file_object,GnomeVFSFileOffset *offset_return)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->tell)
			(captive_file_object,offset_return);
}


GnomeVFSResult captive_file_remove(CaptiveFileObject *captive_file_object)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->remove)
			(captive_file_object);
}


GnomeVFSResult captive_file_file_info_get(CaptiveFileObject *captive_file_object,
		CaptiveFileInfoObject **captive_file_info_object_return)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(captive_file_info_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->file_info_get)
			(captive_file_object,captive_file_info_object_return);
}


GnomeVFSResult captive_file_file_info_set(CaptiveFileObject *captive_file_object,
		CaptiveFileInfoObject *captive_file_info_object,GnomeVFSSetFileInfoMask mask)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(CAPTIVE_FILE_INFO_IS_OBJECT(captive_file_info_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->file_info_set)
			(captive_file_object,captive_file_info_object,mask);
}


GnomeVFSResult captive_file_truncate(CaptiveFileObject *captive_file_object,GnomeVFSFileSize file_size)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object)->truncate)
			(captive_file_object,file_size);
}


GnomeVFSResult captive_file_move(CaptiveFileObject *captive_file_object_old,const gchar *pathname_new,gboolean force_replace)
{
	g_return_val_if_fail(CAPTIVE_FILE_IS_OBJECT(captive_file_object_old),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(pathname_new!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_FILE_OBJECT_GET_CLASS(captive_file_object_old)->move)
			(captive_file_object_old,pathname_new,force_replace);
}
