/* $Id: file.h,v 1.5 2006/01/01 07:24:34 lace Exp $
 * Include file for captive vfs 'file' private interface to reactos
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_FILE_H
#define _CAPTIVE_CLIENT_PRIV_FILE_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include "captive/client-vfs.h"


G_BEGIN_DECLS

struct _CaptiveFileObject {
	GObject parent_instance;

	/*< private >*/
	CaptiveVfsObject *vfs;
	};
struct _CaptiveFileObjectClass {
	GObjectClass parent_class;

	GnomeVFSResult (*read)(CaptiveFileObject *captive_file_object,
			gpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_read_return);
	GnomeVFSResult (*write)(CaptiveFileObject *captive_file_object,
			gconstpointer buffer,GnomeVFSFileSize num_bytes,GnomeVFSFileSize *bytes_written_return);
	GnomeVFSResult (*seek)
			(CaptiveFileObject *captive_file_object,GnomeVFSSeekPosition whence,GnomeVFSFileOffset offset);
	GnomeVFSResult (*tell)(CaptiveFileObject *captive_file_object,GnomeVFSFileOffset *offset_return);
	GnomeVFSResult (*remove)(CaptiveFileObject *captive_file_object);
	GnomeVFSResult (*file_info_get)(CaptiveFileObject *captive_file_object,
			CaptiveFileInfoObject **captive_file_info_object_return);
	GnomeVFSResult (*file_info_set)(CaptiveFileObject *captive_file_object,
			CaptiveFileInfoObject *captive_file_info_object,GnomeVFSSetFileInfoMask mask);
	GnomeVFSResult (*truncate)(CaptiveFileObject *captive_file_object,GnomeVFSFileSize file_size);
	GnomeVFSResult (*move)(CaptiveFileObject *captive_file_object_old,const gchar *pathname_new,gboolean force_replace);
	};

GnomeVFSResult captive_file_init(CaptiveFileObject *captive_file_object,CaptiveVfsObject *captive_vfs_object);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_FILE_H */
