/* $Id: leave.c,v 1.1 2003/05/01 09:13:34 short Exp $
 * Code of leaving libcaptive to be called to cleanup W32 fs state
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/leave.h"	/* self */
#include <glib/gtypes.h>
#include <glib/gmessages.h>
#include "captive/macros.h"
#include <glib/ghook.h>



static GHookList captive_leave_hooklist;


static void captive_leave_hooklist_init(void)
{
	if (captive_leave_hooklist.is_setup)
		return;

	g_hook_list_init(&captive_leave_hooklist,sizeof(GHook));
}


void captive_leave(void)
{
GHookList captive_leave_hooklist_local;

	for (;;) {
		captive_leave_hooklist_init();
		if (!captive_leave_hooklist.hooks)
			break;

		captive_leave_hooklist_local=captive_leave_hooklist;
		captive_leave_hooklist.is_setup=FALSE;

		g_hook_list_invoke(&captive_leave_hooklist_local,
				FALSE);	/* may_recurse */
		g_hook_list_clear(&captive_leave_hooklist_local);
		}
}


void captive_leave_register(captive_leave_func func,gpointer data)
{
GHook *ghook;

	g_return_if_fail(func!=NULL);

	captive_leave_hooklist_init();

	ghook=g_hook_alloc(&captive_leave_hooklist);
	ghook->func=func;
	ghook->data=data;
	g_hook_append(&captive_leave_hooklist,ghook);
}
