/* $Id: libxml.c,v 1.2 2005/12/17 05:19:13 lace Exp $
 * Supplementary captive utilities for libxml2
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/libxml.h"	/* self */
#include <glib/gmessages.h>
#include <glib/ghook.h>
#include <string.h>
#include "captive/macros.h"


struct captive_libxml_string_drop_stack {
	GHookList g_hook_list;
	};


gint64 captive_libxml_sscanf_gint64(const gchar *gint64_string)
{
int errint;
gint64 r;
int gint64_string_len;

	g_return_val_if_fail(gint64_string!=NULL,0);

	errint=sscanf(gint64_string,"%" G_GINT64_FORMAT "%n",&r,&gint64_string_len);
	g_assert(errint==1 || errint==2 /* %n */);
	g_assert(gint64_string_len==(int)strlen(gint64_string));

	return r;
}


static void captive_libxml_string_drop_hook_func(const xmlChar *xml_string /* data */)
{
	g_return_if_fail(xml_string!=NULL);

	xmlFree((xmlChar *)xml_string);
}

G_CONST_RETURN gchar *captive_libxml_string_drop(struct captive_libxml_string_drop_stack **drop_stackp,const xmlChar *xml_string)
{
GHook *g_hook;

	g_return_val_if_fail(drop_stackp!=NULL,NULL);

	if (!xml_string)
		return NULL;

	if (!*drop_stackp) {
		captive_new(*drop_stackp);
		g_hook_list_init(&(*drop_stackp)->g_hook_list,sizeof(GHook));
		}

	g_hook=g_hook_alloc(&(*drop_stackp)->g_hook_list);
	g_hook->func=(GHookFunc)captive_libxml_string_drop_hook_func;
	g_hook->data=(xmlChar *)xml_string;
	g_hook_append(&(*drop_stackp)->g_hook_list,g_hook);

	return (const gchar *)xml_string;
}


void captive_libxml_string_drop_flush(struct captive_libxml_string_drop_stack **drop_stackp)
{
struct captive_libxml_string_drop_stack *drop_stack;

	g_return_if_fail(drop_stackp!=NULL);

	if (!(drop_stack=*drop_stackp))
		return;
	*drop_stackp=NULL;

	g_hook_list_invoke(&drop_stack->g_hook_list,
			FALSE);	/* may_recurse */
	g_hook_list_clear(&drop_stack->g_hook_list);

	g_free(drop_stack);
}
