/* $Id: parent-connector.h,v 1.3 2003/09/22 07:20:29 short Exp $
 * Include file for fs object sandbox parents reconnections to their sandbox slave peers
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_PARENT_CONNECTOR_H
#define _CAPTIVE_CLIENT_PRIV_PARENT_CONNECTOR_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include <glib-object.h>
#include <orbit/orb-core/corba-defs.h>
#include "vfs-parent.h"


G_BEGIN_DECLS

#define CAPTIVE_TYPE_PARENT_CONNECTOR           (captive_parent_connector_get_type ())
#define CAPTIVE_PARENT_CONNECTOR(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAPTIVE_TYPE_PARENT_CONNECTOR, CaptiveParentConnector))
#define CAPTIVE_PARENT_CONNECTOR_CLASS(obj)     (G_TYPE_CHECK_CLASS_CAST ((obj), CAPTIVE_TYPE_PARENT_CONNECTOR, CaptiveParentConnectorIface))
#define CAPTIVE_IS_PARENT_CONNECTOR(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAPTIVE_TYPE_PARENT_CONNECTOR))
#define CAPTIVE_IS_PARENT_CONNECTOR_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE ((obj), CAPTIVE_TYPE_PARENT_CONNECTOR))
#define CAPTIVE_PARENT_CONNECTOR_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CAPTIVE_TYPE_PARENT_CONNECTOR, CaptiveParentConnectorIface))
typedef struct _CaptiveParentConnector      CaptiveParentConnector;
typedef struct _CaptiveParentConnectorIface CaptiveParentConnectorIface;


GType captive_parent_connector_get_type(void);

struct _CaptiveParentConnectorIface {
	GTypeInterface g_iface;

	GnomeVFSResult (*open)(CaptiveParentConnector *captive_parent_connector);
	GnomeVFSResult (*close)(CaptiveParentConnector *captive_parent_connector);
	G_CONST_RETURN gchar *(*get_pathname)(CaptiveParentConnector *captive_parent_connector);
	};

typedef enum {
	CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,
	CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,
	CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ANY,
	} CaptiveParentConnectorFlagWant;

#define CAPTIVE_PARENT_CONNECTOR_FLAGS_DISCONNECTED \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_BROKEN \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_CLOSED \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ANY	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_CLOSED_CLEAN \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_CLOSED_DIRTY \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_CLOSED_DIRTY_OR_OPENED_DIRTY \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ANY,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_DISCONNECTED_OR_CLOSED_CLEAN \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ANY,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_DISCONNECTED_OR_BROKEN_OR_CLOSED \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ANY,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ANY	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_OPENED \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ANY	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_OPENED_CLEAN \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_OFF	/* dirty */
#define CAPTIVE_PARENT_CONNECTOR_FLAGS_OPENED_DIRTY \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* vfs */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON,	/* corba_object */ \
		CAPTIVE_PARENT_CONNECTOR_FLAG_WANT_ON	/* dirty */

void captive_parent_connector_init(CaptiveParentConnector *captive_parent_connector,
			CORBA_Object *corba_objectp,CaptiveVfsParentObject *captive_vfs_parent_object);
gboolean captive_parent_connector_dispose(CaptiveParentConnector *captive_parent_connector);
void captive_parent_connector_finalize(CaptiveParentConnector *captive_parent_connector);
GnomeVFSResult captive_parent_connector_connect(CaptiveParentConnector *captive_parent_connector);
GnomeVFSResult captive_parent_connector_open(CaptiveParentConnector *captive_parent_connector);
GnomeVFSResult captive_parent_connector_close(CaptiveParentConnector *captive_parent_connector);
void captive_parent_connector_set_dirty(CaptiveParentConnector *captive_parent_connector);
CaptiveVfsParentObject *captive_parent_connector_get_captive_vfs_parent_object
		(CaptiveParentConnector *captive_parent_connector);
CORBA_Object captive_parent_connector_get_corba_object(CaptiveParentConnector *captive_parent_connector);
gboolean captive_parent_connector_get_dirty(CaptiveParentConnector *captive_parent_connector);
gboolean captive_parent_connector_is_state(CaptiveParentConnector *captive_parent_connector,
		CaptiveParentConnectorFlagWant vfs_want,
		CaptiveParentConnectorFlagWant corba_object_want,CaptiveParentConnectorFlagWant dirty_want);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_PARENT_CONNECTOR_H */
