/* $Id: result.c,v 1.5 2003/11/06 11:16:12 short Exp $
 * captive vfs result code translation for Gnome-VFS-2.0
 * Copyright (C) 2002-2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "result.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ddk/status.h"	/* for STATUS_* */
#include <libgnomevfs/gnome-vfs-result.h>	/* for GnomeVFSResult */


GnomeVFSResult captive_NTSTATUS_to_GnomeVFSResult(NTSTATUS err)
{
	switch (err) {
		case STATUS_NO_SUCH_FILE:          return GNOME_VFS_ERROR_EOF;	/* ==0 files found */
		case STATUS_NO_MORE_FILES:         return GNOME_VFS_ERROR_EOF;	/* >=1 files found */
		case STATUS_OBJECT_NAME_COLLISION: return GNOME_VFS_ERROR_FILE_EXISTS;
		case STATUS_OBJECT_NAME_NOT_FOUND: return GNOME_VFS_ERROR_NOT_FOUND;
		case STATUS_UNRECOGNIZED_VOLUME:   return GNOME_VFS_ERROR_WRONG_FORMAT;
		case STATUS_OBJECT_NAME_INVALID:   return GNOME_VFS_ERROR_INVALID_URI;
		case STATUS_DIRECTORY_NOT_EMPTY:   return GNOME_VFS_ERROR_DIRECTORY_NOT_EMPTY;
		case STATUS_NOT_A_DIRECTORY:       return GNOME_VFS_ERROR_NOT_A_DIRECTORY;
		case STATUS_INVALID_PARAMETER:     return GNOME_VFS_ERROR_BAD_PARAMETERS;	/* read() of directory handle */
		case STATUS_CANNOT_DELETE:         return GNOME_VFS_ERROR_GENERIC;	/* unlink() of '/' */
		case STATUS_ACCESS_DENIED:         return GNOME_VFS_ERROR_ACCESS_DENIED;	/* mkdir() on r/o device */
		case STATUS_OBJECT_PATH_NOT_FOUND: return GNOME_VFS_ERROR_NOT_FOUND;	/* rename() to nonexist/smth */
		case STATUS_MEDIA_WRITE_PROTECTED: return GNOME_VFS_ERROR_READ_ONLY;
		case STATUS_SHARING_VIOLATION:     return GNOME_VFS_ERROR_DIRECTORY_BUSY;	/* errno EBUSY */
		default:; /* PASSTHRU */
		}
	return GNOME_VFS_OK;	/* undetected */
}
