/* $Id: standalone-gnome.c,v 1.1 2005/12/22 08:22:56 lace Exp $
 * --enable-standalone optional Gnome init for static builds of captive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "standalone-gnome.h"	/* self */
#include <stdlib.h>
#include "standalone.h"
#include <fontconfig/fontconfig.h>


void captive_standalone_gnome_init(void)
{
static gboolean done=FALSE;

	if (done)
		return;

	captive_standalone_init();

#ifdef HAVE_GNOMEUI

#ifdef ENABLE_STANDALONE

	/* Prevent loading of custom theme needing icons which may
	 * be problematic to be loaded by our static binary.
	 * However user still may have specified his/her theme in $HOME.
	 */
	setenv("GTK2_RC_FILES","",
			1);	/* overwrite */

	/* Prevent: Cannot open Input Method ...
	 */
	setenv("GTK_IM_MODULE_FILE","/dev/null",
			1);	/* overwrite */

#endif /* ENABLE_STANDALONE */

#ifdef STANDALONE_FONTSDIR

	/* Prevent handling (even writing!): ~/.fonts.cache-1 */
	FcConfigEnableHome(FcFalse);

	/* Prevent fontconfig loading: /etc/fonts/fonts.conf */
	/* 'fonts_conf_dir' is created by: bundle_files_write() */
	setenv("FONTCONFIG_PATH",STANDALONE_FONTSDIR,
			1);	/* overwrite */

#endif /* STANDALONE_FONTSDIR */

#endif /* HAVE_GNOMEUI */

	done=TRUE;
}
