/* $Id: standalone.c,v 1.4 2006/01/25 17:36:45 lace Exp $
 * General + --enable-standalone optional init for static builds of captive
 * Copyright (C) 2005 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "standalone.h"	/* self */
#include <stdlib.h>
#include <stdio.h>
#include <glib-object.h>
#include <locale.h>


gboolean captive_standalone_init_done=FALSE;

void captive_standalone_init(void)
{
	if (captive_standalone_init_done)
		return;

#ifdef ENABLE_STANDALONE

	/* Prevent glibc loading: /usr/lib/gconv/gconv-modules.cache */
	setenv("GCONV_PATH","/foobar",
			1);	/* overwrite */

	/* Not needed: "LIBCHARSET_ALIAS_DIR"
	 * as prevented by: glib-2.6.4-noaliases.patch
	 */

	/* Do not redefine the 'LANG'/'LC_*' settings to avoid corrupting
	 * filenames charset interpretation.
	 * Do not redefine the 'LOCPATH' settings as we just hope to find
	 * the right definitions - we do not supply any ourselves.
	 * Be sure the locale messages dirs are not ".utf8" suffixed:
	 * glibc-20050524T1606/locale/findlocale.c:
	 * 	If the locale name contains a charset name and the charset name used in
	 * 	the locale (present in the LC_CTYPE data) is not the same (after
	 * 	resolving aliases etc) we reject the locale
	 */
#if 0
	if (getenv("LC_ALL"))
		setenv("LC_MESSAGES",getenv("LC_ALL"),
				1);	/* overwrite */
	if (!getenv("LC_MESSAGES") && getenv("LANG"))
		setenv("LC_MESSAGES",getenv("LANG"),
				1);	/* overwrite */
	setenv("LC_CTYPE","en_US.utf8",
			1);	/* overwrite */
	unsetenv("LANG");
	unsetenv("LC_COLLATE");
	unsetenv("LC_MONETARY");
	unsetenv("LC_NUMERIC");
	unsetenv("LC_TIME");

	/* It may differ across distributions. Maybe - just expected. */
	setenv("LOCPATH",LOCALEDIR,
			1);	/* overwrite */
#endif

#endif /* ENABLE_STANDALONE */

	/* Prevent output block buffering if redirecting stdout to file. */
	setvbuf(stdout,(char *)NULL,_IONBF,0);
	setvbuf(stderr,(char *)NULL,_IONBF,0);

	/* Initialize the i18n stuff */
	setlocale(LC_ALL,"");
	bindtextdomain(PACKAGE,LOCALEDIR);
	textdomain(PACKAGE);

	/* Initialize GObject subsystem of GLib. */
	g_type_init();

	captive_standalone_init_done=TRUE;
}
