/* $Id: vfs-parent.h,v 1.4 2003/12/06 14:04:54 short Exp $
 * Include vfs for captive 'vfs' private interface to reactos of sandbox parent
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_VFS_PARENT_H
#define _CAPTIVE_CLIENT_PRIV_VFS_PARENT_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include <glib-object.h>
#include "captive/client-vfs.h"	/* for CaptiveVfsObject */
#include "vfs.h"	/* for CaptiveVfsObject priv */
#include "../sandbox/sandbox.h"
#include <libxml/tree.h>


G_BEGIN_DECLS

#define CAPTIVE_VFS_PARENT_TYPE_OBJECT            (captive_vfs_parent_object_get_type())
#define CAPTIVE_VFS_PARENT_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_VFS_PARENT_TYPE_OBJECT,CaptiveVfsParentObject))
#define CAPTIVE_VFS_PARENT_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_VFS_PARENT_TYPE_OBJECT,CaptiveVfsParentObjectClass))
#define CAPTIVE_VFS_PARENT_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_VFS_PARENT_TYPE_OBJECT))
#define CAPTIVE_VFS_PARENT_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_VFS_PARENT_TYPE_OBJECT))
#define CAPTIVE_VFS_PARENT_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_VFS_PARENT_TYPE_OBJECT,CaptiveVfsParentObjectClass))
typedef struct _CaptiveVfsParentObject      CaptiveVfsParentObject;
typedef struct _CaptiveVfsParentObjectClass CaptiveVfsParentObjectClass;


GType captive_vfs_parent_object_get_type(void);

struct _CaptiveVfsParentObject {
	CaptiveVfsObject parent_instance;

	Captive_Vfs corba_Vfs_object;
	Captive_GLogFunc corba_GLogFunc_object;
	Captive_CaptiveIOChannel corba_CaptiveIOChannel_object;
	/* It may corba_parent_giochanel_blind_source==options.image_iochannel !
	 * 1st stage           : corba_parent_giochanel_blind
	 * 2nd stage (optional): corba_parent_giochanel_blind_source
	 * 3rd stage (optional): captive_storage_relastblock(options.image_iochannel)
	 * 4rd stage           : options.image_iochannel
	 */
	GIOChannel *corba_parent_giochanel_blind;
	GIOChannel *corba_parent_giochanel_blind_source;
	int corba_parentheart_fds_1;
	gchar *corba_chrooted_orbit_dir;
	gchar *corba_socketname;
	pid_t corba_child_pid;
	xmlDoc *corba_bug_doc;
	xmlNode *corba_bug;
	xmlNode *corba_bug_action;
	xmlNode *corba_bug_log;
	};
struct _CaptiveVfsParentObjectClass {
	CaptiveVfsObjectClass parent_class;

	/* signals */
	void (*detach)(CaptiveVfsParentObject *captive_vfs_parent_object);
	void (*cease)(CaptiveVfsParentObject *captive_vfs_parent_object);
	void (*abort)(CaptiveVfsParentObject *captive_vfs_parent_object);
	};

GnomeVFSResult captive_vfs_parent_object_connect(CaptiveVfsParentObject *captive_vfs_parent_object);
GnomeVFSResult captive_vfs_parent_object_disconnect(CaptiveVfsParentObject *captive_vfs_parent_object);
GnomeVFSResult captive_vfs_parent_object_aborted(CaptiveVfsParentObject *captive_vfs_parent_object);

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_VFS_PARENT_H */
