/* $Id: vfs-slave.c,v 1.1 2003/09/09 17:27:28 short Exp $
 * captive vfs 'vfs' interface to reactos of sandbox slave
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "vfs-slave.h"	/* self */
#include <glib/gmessages.h>
#include "captive/client-vfs.h"	/* for CaptiveVfsObject */
#include "vfs.h"	/* for CaptiveVfsObject priv */
#include "captive/macros.h"
#include "directory.h"
#include "reactos/ddk/iotypes.h"
#include "captive/client-directory.h"
#include "reactos/ntos/zw.h"	/* for NtQueryVolumeInformationFile() */
#include "result.h"
#include "init.h"
#include "directory-slave.h"
#include "file-slave.h"


struct _CaptiveVfsSlaveObject {
	CaptiveVfsObject parent_instance;
	};
struct _CaptiveVfsSlaveObjectClass {
	CaptiveVfsObjectClass parent_class;
	};


static gpointer captive_vfs_slave_object_parent_class=NULL;


static GnomeVFSResult captive_vfs_slave_init(CaptiveVfsObject *captive_vfs_object);
static GnomeVFSResult captive_vfs_slave_close(CaptiveVfsObject *captive_vfs_object);
static GnomeVFSResult captive_vfs_slave_commit(CaptiveVfsObject *captive_vfs_object);
static GnomeVFSResult captive_vfs_slave_volume_info_get
		(CaptiveVfsObject *captive_vfs_object,CaptiveVfsVolumeInfo *volume_info);


static void captive_vfs_slave_object_finalize(CaptiveVfsSlaveObject *captive_vfs_slave_object)
{
	g_return_if_fail(captive_vfs_slave_object!=NULL);

	captive_vfs_slave_close(CAPTIVE_VFS_OBJECT(captive_vfs_slave_object));	/* errors ignored */

	G_OBJECT_CLASS(captive_vfs_slave_object_parent_class)->finalize((GObject *)captive_vfs_slave_object);
}


static void captive_vfs_slave_object_class_init(CaptiveVfsSlaveObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);
CaptiveVfsObjectClass *captive_vfs_object_class=CAPTIVE_VFS_OBJECT_CLASS(class);

	captive_vfs_slave_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_vfs_slave_object_finalize;

	captive_vfs_object_class->init=captive_vfs_slave_init;
	captive_vfs_object_class->commit=captive_vfs_slave_commit;
	captive_vfs_object_class->volume_info_get=captive_vfs_slave_volume_info_get;

	captive_vfs_object_class->directory_new_open=captive_directory_slave_new_open;
	captive_vfs_object_class->directory_new_make=captive_directory_slave_new_make;

	captive_vfs_object_class->file_new_open=captive_file_slave_new_open;
	captive_vfs_object_class->file_new_create=captive_file_slave_new_create;
}


static void captive_vfs_slave_object_init(CaptiveVfsSlaveObject *captive_vfs_slave_object)
{
}


GType captive_vfs_slave_object_get_type(void)
{
static GType captive_vfs_slave_object_type=0;

	if (!captive_vfs_slave_object_type) {
static const GTypeInfo captive_vfs_slave_object_info={
				sizeof(CaptiveVfsSlaveObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_vfs_slave_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptiveVfsSlaveObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_vfs_slave_object_init,
				};

		captive_vfs_slave_object_type=g_type_register_static(CAPTIVE_VFS_TYPE_OBJECT,
				"CaptiveVfsSlaveObject",&captive_vfs_slave_object_info,0);
		}

	return captive_vfs_slave_object_type;
}


static GnomeVFSResult captive_vfs_slave_init(CaptiveVfsObject *captive_vfs_object)
{
CaptiveVfsSlaveObject *captive_vfs_slave_object;
gboolean errbool;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_slave_object=CAPTIVE_VFS_SLAVE_OBJECT(captive_vfs_object);

	g_assert(captive_options==NULL);
	captive_options=&captive_vfs_object->options;

	errbool=captive_init();
	g_assert(errbool==TRUE);

	return GNOME_VFS_OK;
}


static GnomeVFSResult captive_vfs_slave_close(CaptiveVfsObject *captive_vfs_object)
{
CaptiveVfsSlaveObject *captive_vfs_slave_object;
gboolean errbool;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_slave_object=CAPTIVE_VFS_SLAVE_OBJECT(captive_vfs_object);

	g_assert(captive_options==&captive_vfs_object->options);
	errbool=captive_shutdown();
	g_assert(errbool==TRUE);

	captive_options=NULL;

	return GNOME_VFS_OK;
}


static GnomeVFSResult captive_vfs_slave_commit(CaptiveVfsObject *captive_vfs_object)
{
CaptiveVfsSlaveObject *captive_vfs_slave_object;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_slave_object=CAPTIVE_VFS_SLAVE_OBJECT(captive_vfs_object);

	/* We do not buffer any data if not in sandboxed mode. */
	return GNOME_VFS_OK;
}


static GnomeVFSResult captive_vfs_slave_volume_info_get
		(CaptiveVfsObject *captive_vfs_object,CaptiveVfsVolumeInfo *volume_info)
{
CaptiveVfsSlaveObject *captive_vfs_slave_object;
FILE_FS_FULL_SIZE_INFORMATION FileFsFullSizeInformation_local;
NTSTATUS err;
IO_STATUS_BLOCK volume_IoStatusBlock;
GnomeVFSResult errvfsresult;
CaptiveDirectoryObject *captive_directory_object;

	g_return_val_if_fail(CAPTIVE_VFS_SLAVE_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(volume_info!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_vfs_slave_object=CAPTIVE_VFS_SLAVE_OBJECT(captive_vfs_object);

	if (GNOME_VFS_OK!=(errvfsresult=captive_directory_new_open(&captive_directory_object,captive_vfs_object,"/")))
		return errvfsresult;

	err=NtQueryVolumeInformationFile(
			CAPTIVE_DIRECTORY_SLAVE_OBJECT(captive_directory_object)->dir_Handle,	/* FileHandle */
			&volume_IoStatusBlock,	/* IoStatusBlock */
			&FileFsFullSizeInformation_local,	/* FsInformation */
			sizeof(FileFsFullSizeInformation_local),	/* Length */
			FileFsFullSizeInformation);	/* FsInformationClass */
	if (NT_SUCCESS(err)!=NT_SUCCESS(volume_IoStatusBlock.Status)) {
		g_assert_not_reached();
		goto err_unref_captive_directory_object;
		}
	if (GNOME_VFS_OK!=(errvfsresult=captive_NTSTATUS_to_GnomeVFSResult(err)))
		goto err_unref_captive_directory_object;

	g_object_unref(captive_directory_object);

	volume_info->block_size=FileFsFullSizeInformation_local.BytesPerSector
			*FileFsFullSizeInformation_local.SectorsPerAllocationUnit;
	volume_info->bytes          =FileFsFullSizeInformation_local.TotalAllocationUnits.QuadPart          *volume_info->block_size;
	volume_info->bytes_free     =FileFsFullSizeInformation_local.ActualAvailableAllocationUnits.QuadPart*volume_info->block_size;
	volume_info->bytes_available=FileFsFullSizeInformation_local.CallerAvailableAllocationUnits.QuadPart*volume_info->block_size;

	return GNOME_VFS_OK;

err_unref_captive_directory_object:
	g_object_unref(captive_directory_object);
	return errvfsresult;
}
