/* $Id: vfs.c,v 1.16 2005/12/28 06:59:26 lace Exp $
 * captive vfs 'vfs' interface to reactos
 * Copyright (C) 2002-2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "captive/client-vfs.h"	/* self */
#include "vfs.h"	/* self-priv */
#include <glib/gmessages.h>
#include "vfs-parent.h"
#include "vfs-slave.h"
#include "init.h"
#include "lib.h"	/* for captive_giochannel_setup() */
#include <unistd.h>
#include <string.h>


static gpointer captive_vfs_object_parent_class=NULL;


static GnomeVFSResult captive_vfs_close(CaptiveVfsObject *captive_vfs_object);

static void captive_vfs_object_finalize(CaptiveVfsObject *captive_vfs_object)
{
	g_return_if_fail(captive_vfs_object!=NULL);

	captive_vfs_close(captive_vfs_object);	/* errors ignored */

	G_OBJECT_CLASS(captive_vfs_object_parent_class)->finalize((GObject *)captive_vfs_object);
}


static void captive_vfs_object_class_init(CaptiveVfsObjectClass *class)
{
GObjectClass *gobject_class=G_OBJECT_CLASS(class);

	captive_vfs_object_parent_class=g_type_class_ref(g_type_parent(G_TYPE_FROM_CLASS(class)));
	gobject_class->finalize=(void (*)(GObject *object))captive_vfs_object_finalize;
}


static void captive_vfs_object_init(CaptiveVfsObject *captive_vfs_object)
{
	captive_options_init(&captive_vfs_object->options);
}


GType captive_vfs_object_get_type(void)
{
static GType captive_vfs_object_type=0;

	if (!captive_vfs_object_type) {
static const GTypeInfo captive_vfs_object_info={
				sizeof(CaptiveVfsObjectClass),
				NULL,	/* base_init */
				NULL,	/* base_finalize */
				(GClassInitFunc)captive_vfs_object_class_init,
				NULL,	/* class_finalize */
				NULL,	/* class_data */
				sizeof(CaptiveVfsObject),
				5,	/* n_preallocs */
				(GInstanceInitFunc)captive_vfs_object_init,
				};

		captive_vfs_object_type=g_type_register_static(G_TYPE_OBJECT,
				"CaptiveVfsObject",&captive_vfs_object_info,G_TYPE_FLAG_ABSTRACT);
		}

	return captive_vfs_object_type;
}


GnomeVFSResult captive_vfs_new
		(CaptiveVfsObject **captive_vfs_object_return,const struct captive_options *options)
{
CaptiveVfsObject *captive_vfs_object;

	g_return_val_if_fail(captive_vfs_object_return!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(options!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	/* Here is the first initializaton point of parent in sandboxed mode. */
	captive_log_init(options);

	*captive_vfs_object_return=NULL;

	/* We are sandboxing && we are the master */
	if (options->sandbox && (options->sandbox_server_argv || options->sandbox_server_ior))
		captive_vfs_object=g_object_new(
				CAPTIVE_VFS_PARENT_TYPE_OBJECT,	/* object_type */
				NULL);	/* first_property_name; FIXME: support properties */
	else
		captive_vfs_object=g_object_new(
				CAPTIVE_VFS_SLAVE_TYPE_OBJECT,	/* object_type */
				NULL);	/* first_property_name; FIXME: support properties */

	captive_options_copy(&captive_vfs_object->options,options);

	if (captive_vfs_object->options.image_iochannel)
		captive_giochannel_setup(captive_vfs_object->options.image_iochannel);

	*captive_vfs_object_return=captive_vfs_object;

	return (*CAPTIVE_VFS_OBJECT_GET_CLASS(captive_vfs_object)->init)(captive_vfs_object);
}


static GnomeVFSResult captive_vfs_close(CaptiveVfsObject *captive_vfs_object)
{
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	captive_options_free(&captive_vfs_object->options);

	return GNOME_VFS_OK;
}


GnomeVFSResult captive_vfs_commit(CaptiveVfsObject *captive_vfs_object)
{
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_VFS_OBJECT_GET_CLASS(captive_vfs_object)->commit)(captive_vfs_object);
}


GnomeVFSResult captive_vfs_volume_info_get(CaptiveVfsObject *captive_vfs_object,CaptiveVfsVolumeInfo *volume_info)
{
	g_return_val_if_fail(CAPTIVE_VFS_IS_OBJECT(captive_vfs_object),GNOME_VFS_ERROR_BAD_PARAMETERS);
	g_return_val_if_fail(volume_info!=NULL,GNOME_VFS_ERROR_BAD_PARAMETERS);

	return (*CAPTIVE_VFS_OBJECT_GET_CLASS(captive_vfs_object)->volume_info_get)(captive_vfs_object,volume_info);
}
