/* $Id: vfs.h,v 1.9 2003/09/09 17:27:28 short Exp $
 * Include vfs for captive 'vfs' private interface to reactos
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_PRIV_VFS_H
#define _CAPTIVE_CLIENT_PRIV_VFS_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
#include <glib-object.h>
#include "../sandbox/sandbox.h"
#include <libxml/tree.h>
#include "captive/options.h"
#include "captive/client-vfs.h"
#include "captive/client-directory.h"
#include "captive/client-file.h"


G_BEGIN_DECLS

struct _CaptiveVfsObject {
	GObject parent_instance;

	/*< private >*/
	struct captive_options options;
	};
struct _CaptiveVfsObjectClass {
	GObjectClass parent_class;

	GnomeVFSResult (*init)(CaptiveVfsObject *captive_vfs_object);
	GnomeVFSResult (*commit)(CaptiveVfsObject *captive_vfs_object);
	GnomeVFSResult (*volume_info_get)(CaptiveVfsObject *captive_vfs_object,CaptiveVfsVolumeInfo *volume_info);

	GnomeVFSResult (*directory_new_open)(CaptiveDirectoryObject **captive_directory_object_return,
			CaptiveVfsObject *captive_vfs_object,const gchar *pathname);
	GnomeVFSResult (*directory_new_make)(CaptiveDirectoryObject **captive_directory_object_return,
			CaptiveVfsObject *captive_vfs_object,const gchar *pathname,guint perm);

	GnomeVFSResult (*file_new_open)(CaptiveFileObject **captive_file_object_return,
			CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode);
	GnomeVFSResult (*file_new_create)(CaptiveFileObject **captive_file_object_return,
			CaptiveVfsObject *captive_vfs_object,const gchar *pathname,GnomeVFSOpenMode mode,gboolean exclusive,guint perm);
	};

G_END_DECLS


#endif /* _CAPTIVE_CLIENT_PRIV_VFS_H */
