/* $Id: ntfunc.c,v 1.1 2003/01/16 03:37:11 short Exp $
 * reactos registry handling functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include <glib/gmessages.h>


/**
 * ZwOpenKey:
 * @KeyHandle: Returns new opened #HANDLE.
 * @DesiredAccess: Required access privileges to the created registry object handle.
 * @ObjectAttributes: Registry object attributes by InitializeObjectAttributes().
 * %NULL value is forbidden.
 *
 * Opens specified key from the system registry database.
 * libcaptive currently always returns %STATUS_OBJECT_NAME_NOT_FOUND.
 *
 * Returns: %STATUS_OBJECT_NAME_NOT_FOUND
 */
NTSTATUS ZwOpenKey(OUT PHANDLE KeyHandle,IN ACCESS_MASK DesiredAccess,IN POBJECT_ATTRIBUTES ObjectAttributes)
{
	g_return_val_if_fail(ObjectAttributes!=NULL,STATUS_INVALID_PARAMETER);

	return STATUS_OBJECT_NAME_NOT_FOUND;
}
