/* $Id: rtlfunc.c,v 1.6 2003/11/10 20:50:50 short Exp $
 * reactos registry handling functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include <glib/gmessages.h>
#include "captive/unicode.h"
#include "captive/macros.h"


/**
 * RtlQueryRegistryValues:
 * @RelativeTo: Basedir type constant of relative @Path; ignored by libcaptive.
 * @Path: String path or handle to retrieve; ignored by libcaptive.
 * @QueryTable: Table of entries to retrieve; ignored by libcaptive.
 * %NULL value is forbidden.
 * @Context: Userdata to pass to QueryRoutine() (of @QueryTable); ignored by libcaptive.
 * @Environment: Environment variable to use for key expansion; optional; ignored by libcaptive.
 *
 * Retrieves specified key from the system registry database.
 * libcaptive currently always returns %STATUS_OBJECT_NAME_NOT_FOUND
 * except #ULONG value 1 for the key "\captive\filesystem\Parameters\WritingSupport"
 * (for ext2fsd.sys V0.10A).
 *
 * Returns: %STATUS_OBJECT_NAME_NOT_FOUND or %STATUS_SUCCESS if some result returned.
 */
NTSTATUS RtlQueryRegistryValues
		(IN ULONG RelativeTo,IN PCWSTR Path,IN PRTL_QUERY_REGISTRY_TABLE QueryTable,IN PVOID Context,IN PVOID Environment) 
{
const WCHAR *Path__captive_filesystem_Parameters_ucs2=
		captive_utf8_to_UnicodeString_alloca("\\captive\\filesystem\\Parameters")->Buffer;
const WCHAR *QueryTable_WritingSupport_Name_ucs2=
		captive_utf8_to_UnicodeString_alloca("WritingSupport")->Buffer;
const WCHAR *QueryTable_CSDVersion_Name_ucs2=
		captive_utf8_to_UnicodeString_alloca("CSDVersion")->Buffer;
const gchar *RelativeTo_table[]={
		"RTL_REGISTRY_ABSOLUTE",
		"RTL_REGISTRY_SERVICES",
		"RTL_REGISTRY_CONTROL",
		"RTL_REGISTRY_WINDOWS_NT",
		"RTL_REGISTRY_DEVICEMAP",
		"RTL_REGISTRY_USER",
		"RTL_REGISTRY_ENUM",
		};
UNICODE_STRING Path_UnicodeString;

	g_return_val_if_fail(Path!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(QueryTable!=NULL,STATUS_INVALID_PARAMETER);

	Path_UnicodeString.Length=captive_ucs2_strlen(Path)*sizeof(*Path_UnicodeString.Buffer);
	Path_UnicodeString.MaximumLength=Path_UnicodeString.Length+sizeof(*Path_UnicodeString.Buffer);
	Path_UnicodeString.Buffer=(/* de-const */ PWSTR)Path;
	g_log(G_LOG_DOMAIN,G_LOG_LEVEL_DEBUG,"%s: RelativeTo=%s,Path=%s",G_STRLOC,
			(RelativeTo>=0 && RelativeTo<G_N_ELEMENTS(RelativeTo_table)
					? RelativeTo_table[RelativeTo] : captive_printf_alloca("%lu",(unsigned long)RelativeTo)),
					captive_UnicodeString_to_utf8_alloca(&Path_UnicodeString));

	if (RelativeTo==RTL_REGISTRY_ABSOLUTE
			&& captive_ucs2_compare(Path,Path__captive_filesystem_Parameters_ucs2)
			&& QueryTable[0].Name!=NULL
					&& captive_ucs2_compare(QueryTable[0].Name,QueryTable_WritingSupport_Name_ucs2)
			&& QueryTable[0].Flags==(RTL_QUERY_REGISTRY_DIRECT | RTL_QUERY_REGISTRY_REQUIRED)
			&& QueryTable[0].EntryContext!=NULL
			&& QueryTable[1].Name==NULL) {
		*(ULONG *)QueryTable[0].EntryContext=1;	/* => 'EXT2_SUPPORT_WRITING' */
		return STATUS_SUCCESS;
		}

	if (RelativeTo==RTL_REGISTRY_WINDOWS_NT
			&& *Path==0
			&& QueryTable[0].Name!=NULL
					&& captive_ucs2_compare(QueryTable[0].Name,QueryTable_CSDVersion_Name_ucs2)
			&& QueryTable[0].Flags==RTL_QUERY_REGISTRY_DIRECT
			&& QueryTable[0].EntryContext!=NULL
			&& QueryTable[1].Name==NULL) {
		RtlCopyUnicodeString(
				(UNICODE_STRING *)QueryTable->EntryContext,	/* DestinationString */
				captive_utf8_to_UnicodeString_alloca("Service Pack 1"));	/* SourceString */
		return STATUS_SUCCESS;
		}

	return STATUS_OBJECT_NAME_NOT_FOUND;
}
