/* $Id: list.c,v 1.1 2003/01/16 03:38:46 short Exp $
 * reactos list functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/exfuncs.h"
#include <glib/gmessages.h>
#include "reactos/ntos/types.h"	/* for PSLIST_ENTRY */


/**
 * InterlockedPopEntrySList:
 * @ListHead: List to remove the first entry from.
 * %NULL value is forbidden.
 *
 * Function will remove the first item of @ListHead list and returns its entry @PSLIST_ENTRY.
 * Function should behave in multiprocessing safe way - not handled by libcaptive.
 *
 * Returns: The first entry item of @ListHead. Passed @ListHead will have the first item removed.
 * %NULL value if the list was empty.
 */
PSLIST_ENTRY InterlockedPopEntrySList(IN PSLIST_HEADER ListHead)
{
KSPIN_LOCK SpinLock;

	g_return_val_if_fail(ListHead!=NULL,NULL);

	/* TODO:thread */
	KeInitializeSpinLock(&SpinLock);
	return ExInterlockedPopEntrySList(ListHead,&SpinLock);
}


/**
 * InterlockedPushEntrySList:
 * @ListHead: List to insert @ListEntry item to its start.
 * %NULL value is forbidden.
 * @ListEntry: List item to insert to @ListHead.
 * %NULL value is forbidden.
 *
 * Function will insert @ListEntry as the first item of @ListHead list.
 * Function should behave in multiprocessing safe way - not handled by libcaptive.
 *
 * Returns: The previous first entry item of @ListHead (currently the second one).
 * Passed @ListHead will have the first item @ListEntry.
 * Returns %NULL value if the list was empty.
 */
PSLIST_ENTRY InterlockedPushEntrySList(IN PSLIST_HEADER ListHead,IN PSLIST_ENTRY ListEntry)
{
KSPIN_LOCK SpinLock;

	g_return_val_if_fail(ListHead!=NULL,NULL);
	g_return_val_if_fail(ListEntry!=NULL,NULL);

	/* TODO:thread */
	KeInitializeSpinLock(&SpinLock);
	return ExInterlockedPushEntrySList(ListHead,ListEntry,&SpinLock);
}
