/* $Id: time.c,v 1.2 2003/01/20 23:24:24 short Exp $
 * reactos time handling functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/exfuncs.h"	/* self */
#include <glib/gmessages.h>
#include <time.h>


/**
 * ExLocalTimeToSystemTime:
 * @LocalTime: Time value to convert.
 * %NULL value is forbidden.
 * @SystemTime: Returns the converted @LocalTime.
 * %NULL value is forbidden.
 *
 * Converts @LocalTime from the current local-timezone to the internation GMT zone
 * for @SystemTime.
 */
VOID ExLocalTimeToSystemTime(PLARGE_INTEGER LocalTime,PLARGE_INTEGER SystemTime)
{
	g_return_if_fail(LocalTime!=NULL);
	g_return_if_fail(SystemTime!=NULL);

	tzset();
	SystemTime->QuadPart=LocalTime->QuadPart + timezone*G_GINT64_CONSTANT(10000000);
}


/**
 * ExSystemTimeToLocalTime:
 * @SystemTime: Time value to convert.
 * %NULL value is forbidden.
 * @LocalTime: Returns the converted @SystemTime.
 * %NULL value is forbidden.
 *
 * Converts @SystemTime from the internation GMT zone to the current local-timezone
 * for @LocalTime.
 */
VOID ExSystemTimeToLocalTime(PLARGE_INTEGER SystemTime,PLARGE_INTEGER LocalTime)
{
	g_return_if_fail(SystemTime!=NULL);
	g_return_if_fail(LocalTime!=NULL);

	tzset();
	LocalTime->QuadPart=SystemTime->QuadPart - timezone*G_GINT64_CONSTANT(10000000);
}
