/* $Id: work.c,v 1.4 2003/09/23 07:08:58 short Exp $
 * reactos WORK_QUEUE_ITEM handling by libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/exfuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ddk/extypes.h"	/* for WORK_QUEUE_ITEM */
#include <glib/gmain.h>
#include "captive/macros.h"


static gboolean ExQueueWorkItem_idlefunc(WORK_QUEUE_ITEM *WorkItem_copy /* data */)
{
	g_return_val_if_fail(WorkItem_copy!=NULL,FALSE);	/* false=>remove-me */
	g_return_val_if_fail(WorkItem_copy->WorkerRoutine!=NULL,FALSE);	/* false=>remove-me */

	/* typedef VOID STDCALL_FUNC (*PWORKER_THREAD_ROUTINE)(PVOID Parameter); */

	captive_stdcall_call_4((CaptiveStdCallFunc4)WorkItem_copy->WorkerRoutine,
			WorkItem_copy->Parameter);	/* Parameter */
	g_free(WorkItem_copy);

	return FALSE;	/* remove-me */
}

/**
 * ExQueueWorkItem:
 * @WorkItem: Initialized structure of #WORK_QUEUE_ITEM to enqueue.
 * %NULL value is forbidden.
 * @QueueType: Queue priority.
 *
 * Inserts a work item in a queue for one of the system worker threads to
 * process. It will be processed through g_idle_add_full() with priority
 * range %G_PRIORITY_DEFAULT+10 ... %G_PRIORITY_DEFAULT+30.
 *
 * @WorkItem memory address space can be freed even before its function invocation
 * (required by ntfs.sys).
 */
VOID ExQueueWorkItem(PWORK_QUEUE_ITEM WorkItem,WORK_QUEUE_TYPE QueueType)
{
gint priority;
WORK_QUEUE_ITEM *WorkItem_copy;

	g_return_if_fail(WorkItem!=NULL);
	g_return_if_fail(WorkItem->WorkerRoutine!=NULL);

	switch (QueueType) {
		case DelayedWorkQueue:
			priority=G_PRIORITY_DEFAULT+30;	/* positive towards G_PRIORITY_HIGH_IDLE */
			break;
		case CriticalWorkQueue:
			priority=G_PRIORITY_DEFAULT+20;	/* positive towards G_PRIORITY_HIGH_IDLE */
			break;
		case HyperCriticalWorkQueue:
			priority=G_PRIORITY_DEFAULT+10;	/* positive towards G_PRIORITY_HIGH_IDLE */
			break;
		default:
			g_assert_not_reached();
			priority=G_PRIORITY_DEFAULT;
		}

	captive_memdup(WorkItem_copy,WorkItem);
	g_idle_add_full(
			priority,	/* priority */
			(GSourceFunc)ExQueueWorkItem_idlefunc,	/* function */
			WorkItem_copy,	/* data */
			NULL);	/* notify */
}
