/* $Id: filelock.c,v 1.6 2003/02/10 10:08:59 short Exp $
 * reactos file locking functions emulation of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/fsfuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ntos/types.h"	/* for VOID */
#include "reactos/ddk/status.h"	/* for STATUS_SUCCESS */


VOID FsRtlInitializeFileLock(IN PFILE_LOCK FileLock,
		IN PCOMPLETE_LOCK_IRP_ROUTINE CompleteLockIrpRoutine OPTIONAL,IN PUNLOCK_ROUTINE UnlockRoutine OPTIONAL)
{
	g_return_if_fail(FileLock!=NULL);

	FileLock->CompleteLockIrpRoutine=CompleteLockIrpRoutine;
	FileLock->UnlockRoutine=UnlockRoutine;

	/* FIXME: NOT IMPLEMENTED YET */
}


VOID FsRtlUninitializeFileLock(IN PFILE_LOCK FileLock)
{
	g_return_if_fail(FileLock!=NULL);

	/* FIXME: NOT IMPLEMENTED YET */
}


NTSTATUS FsRtlFastUnlockAll(IN PFILE_LOCK FileLock,IN PFILE_OBJECT FileObject,IN PEPROCESS Process,IN PVOID Context OPTIONAL)
{
	g_return_val_if_fail(FileLock!=NULL,STATUS_INVALID_PARAMETER);

	/* FIXME: NOT IMPLEMENTED YET */

	return STATUS_SUCCESS;
}


BOOLEAN FsRtlCheckLockForReadAccess(IN PFILE_LOCK FileLock,IN PIRP Irp)
{
	g_return_val_if_fail(FileLock!=NULL,FALSE);	/* FALSE means 'no access */
	g_return_val_if_fail(Irp!=NULL,FALSE);	/* FALSE means 'no access */

	return TRUE;	/* permit access */
}


BOOLEAN FsRtlCheckLockForWriteAccess(IN PFILE_LOCK FileLock,IN PIRP Irp)
{
	g_return_val_if_fail(FileLock!=NULL,FALSE);	/* FALSE means 'no access */
	g_return_val_if_fail(Irp!=NULL,FALSE);	/* FALSE means 'no access */

	return TRUE;	/* permit access */
} 


PFILE_LOCK_INFO FsRtlGetNextFileLock(IN PFILE_LOCK FileLock,IN BOOLEAN Restart)
{
	g_return_val_if_fail(FileLock!=NULL,FALSE);	/* FALSE means 'no access */

	return NULL;	/* no known locked byte range */
}
