/* $Id: name_pass.c,v 1.1 2003/02/11 04:07:24 short Exp $
 * reactos filesystem name strings "pass"-redirector emulation of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/fsfuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/internal/module.h"	/* for MODULE_OBJECT */
#include "reactos/internal/ldr.h"	/* for LdrGetModuleObject() */
#include "captive/unicode.h"


UCHAR **FsRtlLegalAnsiCharacterArray;


/* Declared only inside ntoskrnl/ldr/loader.c scope. */
PVOID LdrGetExportAddress(PMODULE_OBJECT ModuleObject,char *Name,unsigned short Hint);

/**
 * captive_FsRtlLegalAnsiCharacterArray_init:
 *
 * Initialize #FsRtlLegalAnsiCharacterArray character classes
 * by appropriate #FSRTL_FAT_LEGAL etc. flags.
 */
void captive_FsRtlLegalAnsiCharacterArray_init(void)
{
MODULE_OBJECT *ntoskrnl_exe_ModuleObject;
UCHAR **exported;

	ntoskrnl_exe_ModuleObject=LdrGetModuleObject(captive_utf8_to_UnicodeString_alloca("ntoskrnl.exe"));
	g_assert(ntoskrnl_exe_ModuleObject!=NULL);

	exported=LdrGetExportAddress(
			ntoskrnl_exe_ModuleObject,	/* ModuleObject */
			"FsRtlLegalAnsiCharacterArray",	/* Name */
			0);	/* Hint */
	g_assert(exported!=NULL);

	g_assert(*exported!=NULL);
	FsRtlLegalAnsiCharacterArray=exported;
}
