/* $Id: notify.c,v 1.1 2003/03/29 20:58:53 short Exp $
 * reactos filesystem notification functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

/* no prototype for FsRtlNotifyFilterChangeDirectory() */
#include <glib/gmessages.h>
#include "reactos/base.h"	/* for VOID etc. */
#include "reactos/ddk/fstypes.h"	/* for PNOTIFY_SYNC */
#include "reactos/ddk/fsfuncs.h"	/* for PCHECK_FOR_TRAVERSE_ACCESS */


typedef BOOLEAN (*PFILTER_REPORT_CHANGE)(IN PVOID NotifyContext,IN PVOID FilterContext); 

/**
 * FsRtlNotifyFilterChangeDirectory:
 * @NotifySync: IGNORED; ignored by libcaptive.
 * %NULL value is forbidden.
 * @NotifyList: IGNORED; ignored by libcaptive.
 * %NULL value is forbidden.
 * @FsContext: IGNORED; ignored by libcaptive.
 * @FullDirectoryName: IGNORED; ignored by libcaptive.
 * %NULL value is permitted.
 * @WatchTree: IGNORED; ignored by libcaptive.
 * @IgnoreBuffer: IGNORED; ignored by libcaptive.
 * @CompletionFilter: IGNORED; ignored by libcaptive.
 * @NotifyIrp: IGNORED; ignored by libcaptive.
 * %NULL value is permitted.
 * @TraverseCallback: IGNORED; ignored by libcaptive.
 * @SubjectContext: IGNORED; ignored by libcaptive.
 * @FilterCallback: IGNORED; ignored by libcaptive.
 *
 * libcaptive does not support any filesystem filter drivers and therefore
 * the function is implemented as no-operation.
 */
VOID FsRtlNotifyFilterChangeDirectory(IN PNOTIFY_SYNC NotifySync,IN PLIST_ENTRY NotifyList,
		IN PVOID FsContext,IN PSTRING FullDirectoryName,IN BOOLEAN WatchTree,IN BOOLEAN IgnoreBuffer,
		IN ULONG CompletionFilter,IN PIRP NotifyIrp,IN PCHECK_FOR_TRAVERSE_ACCESS TraverseCallback OPTIONAL,
		IN PSECURITY_SUBJECT_CONTEXT SubjectContext OPTIONAL,IN PFILTER_REPORT_CHANGE FilterCallback OPTIONAL)
{
	g_return_if_fail(NotifySync!=NULL);
	g_return_if_fail(NotifyList!=NULL);
	/* 'FullDirectoryName' may be NULL */
	/* 'NotifyIrp' may be NULL */

	/* NOP */
}
