/* $Id: oplock.c,v 1.4 2003/02/01 00:26:45 short Exp $
 * reactos filesystem oplock functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/fsfuncs.h"	/* self */
#include "reactos/ddk/status.h"	/* for STATUS_SUCCESS */
#include <glib/gmessages.h>


VOID FsRtlInitializeOplock(IN OUT POPLOCK Oplock)
{
	g_return_if_fail(Oplock!=NULL);

	/* FIXME: NOT IMPLEMENTED YET */
}


VOID FsRtlUninitializeOplock(IN OUT POPLOCK Oplock)
{
	g_return_if_fail(Oplock!=NULL);

	/* FIXME: NOT IMPLEMENTED YET */
}


/**
 * FsRtlCheckOplock:
 * @Oplock: ???.
 * %NULL value is forbidden.
 * @Irp: ???.
 * %NULL value is forbidden.
 * @Context: ???.
 * %NULL value is permitted.
 * @CompletionRoutine: ???.
 * %NULL value is permitted.
 * @PostIrpRoutine:
 * %NULL value is permitted.
 *
 * libcaptive does not support any oplocks. This function is a NOP.
 *
 * Returns: %STATUS_SUCCESS.
 */
NTSTATUS FsRtlCheckOplock(IN POPLOCK Oplock,IN PIRP Irp,IN PVOID Context,
		IN POPLOCK_WAIT_COMPLETE_ROUTINE CompletionRoutine OPTIONAL,IN POPLOCK_FS_PREPOST_IRP PostIrpRoutine OPTIONAL)
{
	g_return_val_if_fail(Oplock!=NULL,STATUS_INVALID_PARAMETER);
	g_return_val_if_fail(Irp!=NULL,STATUS_INVALID_PARAMETER);

	/* NOP */

	return STATUS_SUCCESS;
}


BOOLEAN FsRtlCurrentBatchOplock(IN POPLOCK Oplock)
{
	g_return_val_if_fail(Oplock!=NULL,FALSE);

	/* NOP */

	return FALSE; /* no oplock operation pending */
}
