/* $Id: tunnel.c,v 1.1 2003/01/16 03:43:25 short Exp $
 * reactos tunnel (deleted files) database functions emulation of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/fsfuncs.h"	/* self */
#include <glib/gmessages.h>
#include "reactos/ntos/types.h"	/* for VOID */
#include "reactos/ddk/exfuncs.h"	/* for ExInitializeFastMutex() */


/**
 * FsRtlAddToTunnelCache:
 * @Cache: Tunnel cache initialized by FsRtlInitializeTunnelCache().
 * %NULL value or uninitialized structure is forbidden.
 * @DirectoryKey: Unique #ULONGLONG to identify the parent directory on the volume.
 * @ShortName: Shortname of the entry to add.
 * %NULL value forbidden if @KeyByShortName==%TRUE.
 * @LongName: Longname of the entry to add.
 * %NULL value forbidden if @KeyByShortName==%FALSE.
 * @DataLength: Size of @Data to store with the entry. This value must be the same for the whole @Cache.
 * @Data: Data to store with the entry.
 * %NULL value permitted if @DataLength==0.
 *
 * Stores the given entry name pair associated with the given directory.
 * It may get handy to keep the same shortname or longname after its recreation later.
 * FIXME: Currently not yet implemented by libcaptive. It may get handy to keep
 * shortnames/longnames the same during crossfilesystem copying.
 */
VOID FsRtlAddToTunnelCache(IN PTUNNEL Cache,IN ULONGLONG DirectoryKey,IN PUNICODE_STRING ShortName,IN PUNICODE_STRING LongName,IN BOOLEAN KeyByShortName,IN ULONG DataLength,IN PVOID Data)
{
	g_return_if_fail(Cache!=NULL);
	g_return_if_fail(ShortName!=NULL || KeyByShortName==FALSE);
	g_return_if_fail(LongName!=NULL || KeyByShortName==TRUE);
	g_return_if_fail(DataLength==0 || Data!=NULL);

	/* NOP now */
}


/**
 * FsRtlDeleteKeyFromTunnelCache:
 * @Cache: Tunnel cache initialized by FsRtlInitializeTunnelCache().
 * %NULL value or uninitialized structure is forbidden.
 * @DirectoryKey: Unique #ULONGLONG to identify the directory on the volume.
 *
 * Deletes the given directory @DirectoryKey from Tunnel cache @Cache.
 * All the directory's entries are deleted.
 */
VOID FsRtlDeleteKeyFromTunnelCache(IN PTUNNEL Cache,IN ULONGLONG DirectoryKey)
{
	g_return_if_fail(Cache!=NULL);

	/* NOP now */
}


/**
 * FsRtlDeleteTunnelCache:
 * @Cache: Tunnel cache initialized by FsRtlInitializeTunnelCache().
 * %NULL value or uninitialized structure is forbidden.
 *
 * Deletes the whole @Caceh and frees all its resources. You may no longer pass
 * this @Cache to any FsRtl*TunnelCache() function.
 */
VOID FsRtlDeleteTunnelCache(IN PTUNNEL Cache)
{
	g_return_if_fail(Cache!=NULL);

	/* NOP now */
}


/**
 * FsRtlFindInTunnelCache:
 * @Cache: Tunnel cache initialized by FsRtlInitializeTunnelCache().
 * %NULL value or uninitialized structure is forbidden.
 * @DirectoryKey: Unique #ULONGLONG to identify the parent directory on the volume.
 * @Name: Name to search for; either shortname or longname.
 * %NULL value is forbidden.
 * @ShortName: Returns shortname of the found entry if successful.
 * %NULL value is forbidden.
 * @LongName: Returns longname of the found entry if successful.
 * %NULL value is forbidden.
 * @DataLength: Size of @Data to fill-in/returned. This value must be the same for the whole @Cache.
 * %NULL pointer is forbidden.
 * @Data: Returns filed-in data associated with the tunnelled entry.
 * %NULL value permitted if @*DataLength==0.
 *
 * Finds the given entry in the specified Tunnel cache @Cache; either by its stored
 * shortname or the longname.
 * FIXME: Currently not yet implemented by libcaptive. It may get handy to keep
 * shortnames/longnames the same during crossfilesystem copying.
 *
 * Returns: %TRUE if the entry was found. FIXME: libcaptive always returns %FALSE.
 */
BOOLEAN FsRtlFindInTunnelCache(IN PTUNNEL Cache,IN ULONGLONG DirectoryKey,IN PUNICODE_STRING Name,OUT PUNICODE_STRING ShortName,OUT PUNICODE_STRING LongName,IN OUT PULONG DataLength,OUT PVOID Data)
{
	g_return_val_if_fail(Cache!=NULL,FALSE);
	g_return_val_if_fail(Name!=NULL,FALSE);
	g_return_val_if_fail(DataLength!=NULL,FALSE);
	g_return_val_if_fail(*DataLength==0 || Data!=NULL,FALSE);

	return FALSE;	/* not found */
}


/**
 * FsRtlInitializeTunnelCache:
 * @Cache: Allocated Tunnel cache memory to initialize.
 * %NULL value is forbidden.
 *
 * Initializes given @Cache to use it later for FsRtl*TunnelCache() functions.
 */
VOID FsRtlInitializeTunnelCache(IN PTUNNEL Cache)
{
	g_return_if_fail(Cache!=NULL);

	ExInitializeFastMutex(&Cache->Mutex);
	/* FIXME: PRTL_SPLAY_LINKS Cache->Cache */
	Cache->NumEntries=0;
}
