/* $Id: util.c,v 1.1 2003/01/17 01:17:03 short Exp $
 * reactos filesystem oplock functions emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/fsfuncs.h"	/* self */
#include "reactos/ddk/status.h"	/* for STATUS_SUCCESS */
#include <glib/gmessages.h>


/**
 * FsRtlBalanceReads:
 * @TargetDevice: Existing device to start mirring operations on.
 *
 * Called by filesystem to indicate to mirroting subsystem it is now safe
 * to start mirroring operations on its device.
 *
 * libcaptive does not support mirroring; this function is a NOP.
 *
 * Returns: %STATUS_SUCCESS.
 */
NTSTATUS FsRtlBalanceReads(IN PDEVICE_OBJECT TargetDevice)
{
	g_return_val_if_fail(TargetDevice!=NULL,STATUS_INVALID_PARAMETER);

	return STATUS_SUCCESS;
}
