/* $Id: intrlck.c,v 1.4 2003/01/16 03:45:22 short Exp $
 * reactos inter lock increments emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/exfuncs.h"	/* self */


/**
 * InterlockedIncrement:
 * @Addend: #LONG variable to be +1ed.
 *
 * Adds 1 to a #LONG variable and returns.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is just a simple increment now.
 *
 * Returns: a negative number if the @result < %0,
 * zero if the @result == %0
 * a positive number if the @result > %0.
 * The returned number need not be equal to the result!!!!
 */
LONG InterlockedIncrement(PLONG Addend)
{
	/* TODO:thread; really? */
	return ++*Addend;
}


/**
 * InterlockedDecrement:
 * @Addend: #LONG variable to be -1ed.
 *
 * Subtracts 1 from a #LONG variable and returns.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is just a simple decrement now.
 *
 * Returns: a negative number if the @result < %0,
 * zero if the @result == %0
 * a positive number if the @result > %0.
 * The returned number need not be equal to the result!!!!
 */
LONG InterlockedDecrement(PLONG Subend)
{
	/* TODO:thread; really? */
	return --*Subend;
}


/**
 * InterlockedExchange:
 * @Target: Pointer to #LONG variable to exchange @Value with.
 * @Value: Value to store to @Target value.
 *
 * Atomic value exchange between *@Target and @Value.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is just a simple value exchange now.
 *
 * Returns: Previous value of @Target;
 */
LONG InterlockedExchange(PLONG Target,LONG Value)
{
LONG r;

	/* TODO:thread */
	r=*Target;
	*Target=Value;
	return r;
}


/**
 * InterlockedExchangeAdd:
 * @Addend: Pointer to #LONG variable to add @Value to.
 * @Value: Value to add to @Addend value.
 *
 * Atomic value add of @Value to *@Addend.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is just a simple value add now.
 *
 * Returns: Previous value of *@Addend;
 */
LONG InterlockedExchangeAdd(PLONG Addend,LONG Value)
{
LONG r;

	/* TODO:thread */
	r=*Addend;
	*Addend+=Value;
	return r;
}
