/* $Id: perfcnt.c,v 1.2 2003/03/27 15:47:44 short Exp $
 * reactos performance counters emulation of libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

#include "reactos/ddk/kefuncs.h"	/* self */
#include <sys/time.h>
#include <glib/gmessages.h>


/**
 * KeQueryPerformanceCounter:
 * @PerformanceFreq: Optionally returns the number of ticks per second.
 * %NULL value is permitted.
 *
 * Reports the current system-wide timer value.
 *
 * Returns: Current system timer ticks count with unspecified base.
 * You will want to subtract two such values to get some timing result.
 * libcaptive must return #gint64 instead of the official #LARGE_INTEGER
 * as W32 expects it as value in EAX:EDX but GCC returns the structure address in EAX.
 */
gint64 /* instead of LARGE_INTEGER */ KeQueryPerformanceCounter(PLARGE_INTEGER PerformanceFreq)
{
LARGE_INTEGER	r;
struct timeval tv;
int errint;

	errint=gettimeofday(
			&tv,	/* tv */
			NULL);	/* tz */
	g_assert(errint==0);

	r.QuadPart=((guint64)tv.tv_sec)*1000000+tv.tv_usec;

	if (PerformanceFreq)
		PerformanceFreq->QuadPart=1000000;

	return r.QuadPart;
}
