/* $Id: queuedspinlock.c,v 1.3 2003/03/28 20:16:27 short Exp $
 * reactos queued spinlock emulation of libcaptive
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "config.h"

/* no reactos prototype for KeAcquireQueuedSpinLock() and KeReleaseQueuedSpinLock() */
#include "reactos/ddk/types.h"	/* for KIRQL */
#include "reactos/ddk/kefuncs.h"	/* for KeGetCurrentIrql() */
#include <glib/gmessages.h>


typedef enum _KSPIN_LOCK_QUEUE_NUMBER {
	LockQueueDispatcherLock,
	LockQueueContextSwapLock,
	LockQueuePfnLock,
	LockQueueSystemSpaceLock,
	LockQueueVacbLock,
	LockQueueMasterLock,
	LockQueueNonPagedPoolLock,
	LockQueueIoCancelLock,
	LockQueueWorkQueueLock,
	LockQueueIoVpbLock,
	LockQueueIoDatabaseLock,
	LockQueueIoCompletionLock,
	LockQueueNtfsStructLock,
	LockQueueAfdWorkQueueLock,
	LockQueueBcbLock,
	LockQueueMaximumLock
	} KSPIN_LOCK_QUEUE_NUMBER, *PKSPIN_LOCK_QUEUE_NUMBER;


/**
 * KeAcquireQueuedSpinLock:
 * @Number: Identification number of queued spinlock to acquire.
 *
 * Acquires a queued spinlock identified by @Number.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now. #GMutex would be needed otherwise.
 *
 * See http://www.compuware.co.jp/drivercentral/resources/spinlocks.asp
 *
 * Returns: IRQ level before this call. FIXME: What is expected in real? No W32 doc...
 */
KIRQL KeAcquireQueuedSpinLock(IN KSPIN_LOCK_QUEUE_NUMBER Number)
{
	/* TODO:thread */

	return KeGetCurrentIrql();
}


/**
 * KeReleaseQueuedSpinLock:
 * @Number: Identification number of queued spinlock to release.
 * @OldIrql: Original IRQ level before KeAcquireQueuedSpinLock().
 *
 * Releases a queued spinlock acquired by KeAcquireQueuedSpinLock().
 * Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now. #GMutex would be needed otherwise.
 */
VOID KeReleaseQueuedSpinLock(IN KSPIN_LOCK_QUEUE_NUMBER Number,IN KIRQL OldIrql)
{
	/* TODO:thread */
}


/**
 * KeAcquireQueuedSpinLockRaiseToSynch:
 * @Number: Identification number of queued spinlock to acquire.
 *
 * Acquires a queued spinlock identified by @Number.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now. #GMutex would be needed otherwise.
 *
 * FIXME: This functions has unknown prototype and functionality, it was only guessed.
 *
 * See http://www.compuware.co.jp/drivercentral/resources/spinlocks.asp
 *
 * Returns: IRQ level before this call. FIXME: What is expected in real? No W32 doc...
 */
KIRQL KeAcquireQueuedSpinLockRaiseToSynch(IN KSPIN_LOCK_QUEUE_NUMBER Number)	/* FIXME: unknown prototype! */
{
	/* TODO:thread */

	return KeGetCurrentIrql();
}


typedef struct _KSPIN_LOCK_QUEUE {
	struct _KSPIN_LOCK_QUEUE * volatile Next;
	PKSPIN_LOCK volatile Lock;
	} KSPIN_LOCK_QUEUE, *PKSPIN_LOCK_QUEUE;

typedef struct _KLOCK_QUEUE_HANDLE {
	KSPIN_LOCK_QUEUE LockQueue;
	KIRQL OldIrql;
	} KLOCK_QUEUE_HANDLE,*PKLOCK_QUEUE_HANDLE;


/**
 * KeAcquireInStackQueuedSpinLock:
 * @SpinLock: Spin lock structure to acquire.
 * %NULL value is forbidden.
 * @LockHandle: Handle to later pass to KeReleaseInStackQueuedSpinLock().
 * %NULL value is forbidden.
 *
 * Acquires a queued spinlock @SpinLock.
 * You must not mix this call with KeAcquireQueuedSpinLock() for the same @SpinLock.
 * Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now. #GMutex would be needed otherwise.
 */
VOID KeAcquireInStackQueuedSpinLock(IN PKSPIN_LOCK SpinLock,IN PKLOCK_QUEUE_HANDLE LockHandle)
{
	g_return_if_fail(SpinLock!=NULL);
	g_return_if_fail(LockHandle!=NULL);

	/* TODO:thread */
}


/**
 * KeReleaseInStackQueuedSpinLock:
 * @LockHandle: Handle from the acquire by KeAcquireInStackQueuedSpinLock().
 * %NULL value is forbidden.
 *
 * Releases a queued spinlock acquired by KeAcquireInStackQueuedSpinLock().
 * Currently libcaptive doesn't use multithreading
 * and thus this function is a NOP now. #GMutex would be needed otherwise.
 */
VOID KeReleaseInStackQueuedSpinLock(IN PKLOCK_QUEUE_HANDLE LockHandle)
{
	g_return_if_fail(LockHandle!=NULL);

	/* TODO:thread */
}
