/* $Id: calltype_reactos.h,v 1.2 2003/09/23 07:08:58 short Exp $
 * Include file for function call types definitions for reactos files for libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CALLTYPE_REACTOS_H
#define _CAPTIVE_CALLTYPE_REACTOS_H 1


#include <glib/gmacros.h>
#include <glib/gtypes.h>
/* captive/?*_reactos.h include files have forbidden any reactos/?* inclusions
 * as they are being included by reactos/compat.h.
 */


G_BEGIN_DECLS

/**
 * CAPTIVE_CDECL:
 *
 * Function call type declaration for the real #CDECL call type.
 * As the default #CDECL macro gets disabled (=NOP) during reactos sources
 * compilation (and gets undefined to cause error during non-reactos sources
 * compilation) you have the chance to do the real #CDECL declaration
 * by using #CAPTIVE_CDECL. You must #ifdef it by %LIBCAPTIVE symbol as it
 * is not available during standalone reactos compilation.
 *
 * This macro may be needed to pass control to W32 binary code.
 */
#define CAPTIVE_CDECL    __attribute__((__cdecl__))


/**
 * CAPTIVE_STDCALL:
 *
 * Function call type declaration for the real #STDCALL call type.
 * As the default #STDCALL macro gets disabled (=NOP) during reactos sources
 * compilation (and gets undefined to cause error during non-reactos sources
 * compilation) you have the chance to do the real #STDCALL declaration
 * by using #CAPTIVE_STDCALL. You must #ifdef it by %LIBCAPTIVE symbol as it
 * is not available during standalone reactos compilation.
 *
 * This macro may be needed to pass control to W32 binary code.
 */
#define CAPTIVE_STDCALL  __attribute__((__stdcall__))


/**
 * CAPTIVE_FASTCALL:
 *
 * You cannot do simple declaration for the real #FASTCALL call type.
 *
 * You should not need it as the non-core W32 binary code does not use #FASTCALL
 * functions.
 */
#undef CAPTIVE_FASTCALL


typedef gpointer CAPTIVE_STDCALL (*CaptiveStdCallFunc4 )(gpointer arg0);
typedef gpointer CAPTIVE_STDCALL (*CaptiveStdCallFunc8 )(gpointer arg0,gpointer arg1);
typedef gpointer CAPTIVE_STDCALL (*CaptiveStdCallFunc12)(gpointer arg0,gpointer arg1,gpointer arg2);

gpointer captive_stdcall_call_4 (CaptiveStdCallFunc4  func,gpointer arg0);
gpointer captive_stdcall_call_8 (CaptiveStdCallFunc8  func,gpointer arg0,gpointer arg1);
gpointer captive_stdcall_call_12(CaptiveStdCallFunc12 func,gpointer arg0,gpointer arg1,gpointer arg2);

G_END_DECLS


#endif /* _CAPTIVE_CALLTYPE_REACTOS_H */
