/* $Id: captivemodid.h,v 1.7 2005/12/27 09:05:29 lace Exp $
 * Include file for W32 disk modules identifier for acquiration installation utility
 * Copyright (C) 2003 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CAPTIVEMODID_H
#define _CAPTIVE_CAPTIVEMODID_H 1


#ifdef HAVE_LIBXML_XMLREADER_H

#include <glib/gtypes.h>
#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-file-size.h>
#include <libxml/tree.h>	/* for xmlChar */
#include <glib/ghash.h>


G_BEGIN_DECLS

#define CAPTIVE_CAPTIVEMODID_TYPE_OBJECT            (captive_captivemodid_object_get_type())
#define CAPTIVE_CAPTIVEMODID_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_CAPTIVEMODID_TYPE_OBJECT,CaptiveCaptivemodidObject))
#define CAPTIVE_CAPTIVEMODID_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_CAPTIVEMODID_TYPE_OBJECT,CaptiveCaptivemodidObjectClass))
#define CAPTIVE_CAPTIVEMODID_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_CAPTIVEMODID_TYPE_OBJECT))
#define CAPTIVE_CAPTIVEMODID_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_CAPTIVEMODID_TYPE_OBJECT))
#define CAPTIVE_CAPTIVEMODID_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_CAPTIVEMODID_TYPE_OBJECT,CaptiveCaptivemodidObjectClass))
typedef struct _CaptiveCaptivemodidObject      CaptiveCaptivemodidObject;
typedef struct _CaptiveCaptivemodidObjectClass CaptiveCaptivemodidObjectClass;


GType captive_captivemodid_object_get_type(void);


struct captive_captivemodid_module {
	const xmlChar *type;
	gint length;
	const xmlChar *md5;
	const xmlChar *id;
	gint priority;
	gint cabinet_used;
	};

extern void (*captive_captivemodid_module_best_priority_notify)(const gchar *module_type);

CaptiveCaptivemodidObject *captive_captivemodid_load(const gchar *captive_captivemodid_pathname);
CaptiveCaptivemodidObject *captive_captivemodid_load_default(gboolean fatal);
const gchar *captive_captivemodid_get_pathname_loaded(CaptiveCaptivemodidObject *captivemodid);
gboolean captive_captivemodid_module_length_is_valid(CaptiveCaptivemodidObject *captivemodid,GnomeVFSFileSize file_size);
struct captive_captivemodid_module *captive_captivemodid_module_md5_lookup
		(CaptiveCaptivemodidObject *captivemodid,const gchar *file_md5);
gint captive_captivemodid_module_type_best_priority_lookup
		(CaptiveCaptivemodidObject *captivemodid,const xmlChar *module_type);
gboolean captive_captivemodid_module_type_best_priority_found
		(CaptiveCaptivemodidObject *captivemodid,const xmlChar *module_type);
gint captive_captivemodid_cabinet_length_to_used(CaptiveCaptivemodidObject *captivemodid,gint cabinet_length);

gchar *captive_calc_md5(gconstpointer base,size_t length);

G_END_DECLS

#endif /* HAVE_LIBXML_XMLREADER_H */


#endif /* _CAPTIVE_CAPTIVEMODID_H */
