/* $Id: client-directory.h,v 1.9 2006/01/01 07:24:34 lace Exp $
 * Include file with client-application 'directory' access to libcaptive
 * Copyright (C) 2002 Jan Kratochvil <project-captive@jankratochvil.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; exactly version 2 of June 1991 is required
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _CAPTIVE_CLIENT_DIRECTORY_H
#define _CAPTIVE_CLIENT_DIRECTORY_H 1


#include <glib/gmacros.h>
#include <glib-object.h>
#include <libgnomevfs/gnome-vfs-file-info.h>	/* for GnomeVFSFileInfo */
#include "captive/client-file-info.h"
#include "captive/client-vfs.h"


G_BEGIN_DECLS

#define CAPTIVE_DIRECTORY_TYPE_OBJECT            (captive_directory_object_get_type())
#define CAPTIVE_DIRECTORY_OBJECT(object)         (G_TYPE_CHECK_INSTANCE_CAST((object),CAPTIVE_DIRECTORY_TYPE_OBJECT,CaptiveDirectoryObject))
#define CAPTIVE_DIRECTORY_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),CAPTIVE_DIRECTORY_TYPE_OBJECT,CaptiveDirectoryObjectClass))
#define CAPTIVE_DIRECTORY_IS_OBJECT(object)      (G_TYPE_CHECK_INSTANCE_TYPE((object),CAPTIVE_DIRECTORY_TYPE_OBJECT))
#define CAPTIVE_DIRECTORY_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),CAPTIVE_DIRECTORY_TYPE_OBJECT))
#define CAPTIVE_DIRECTORY_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj),CAPTIVE_DIRECTORY_TYPE_OBJECT,CaptiveDirectoryObjectClass))
typedef struct _CaptiveDirectoryObject      CaptiveDirectoryObject;
typedef struct _CaptiveDirectoryObjectClass CaptiveDirectoryObjectClass;


GType captive_directory_object_get_type(void);

GnomeVFSResult captive_directory_new_open(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname);
GnomeVFSResult captive_directory_new_make(CaptiveDirectoryObject **captive_directory_object_return,
		CaptiveVfsObject *captive_vfs_object,const gchar *pathname,guint perm);
CaptiveVfsObject *captive_directory_ref_vfs(CaptiveDirectoryObject *captive_directory_object);
GnomeVFSResult captive_directory_read(CaptiveDirectoryObject *captive_directory_object,
		CaptiveFileInfoObject **captive_file_info_object_return);
GnomeVFSResult captive_directory_remove(CaptiveDirectoryObject *captive_directory_object);


G_END_DECLS


#endif /* _CAPTIVE_CLIENT_DIRECTORY_H */
